/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PREVIEW_H
#define PREVIEW_H

#include <qscrollview.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>

class KPrinter;
class KXStitchDoc;

/** Display a preview of the pattern
    @author Stephen P. Allewell
  */
class PreView : public QScrollView
{
  Q_OBJECT
public:
/** Constructor
    @param doc Pointer to the KXStitchDoc object.
    @param parent Pointer to the parent KXStitchView object.
  */
  PreView(KXStitchDoc* doc, QWidget* parent);
/** Print a front page using the preview image
    and information from the document for headers
  */
  int print(KPrinter *printer, QPainter *painter, int width, int height, int pages);
  
public slots:
/** Set the top left x,y coordinate and the width and height
    of the cells visible within the editor window.
    @param cells QRect defining the visible area.
  */
  void setVisibleCells(QRect cells);

signals:
/** Emitted when the user clicks on a point within the preview window
  */
  void clicked(QPoint pos);

protected:
/** Reimplemented from the base class.
    Called when a mouse button is pressed within the preview window
    @param e QMouseEvent describing the mouse action.
  */
  virtual void contentsMousePressEvent(QMouseEvent* e);
/** Reimplemented from the base class.
    Called when a mouse is moved within the preview window whilst a
    button is held down.
    @param e QMouseEvent describing the mouse action.
  */
  virtual void contentsMouseMoveEvent(QMouseEvent* e);
/** Reimplemented from the base class.
    Called when a mouse button is released within the preview window
    @param e QMouseEvent describing the mouse action.
  */
  virtual void contentsMouseReleaseEvent(QMouseEvent* e);
/** Reimplemented from the base class.
    Called to repaint the contents of the preview window.
    @param p Pointer to the QPainter to be used for painting.
    @param cx Top left x position of area to be repainted.
    @param cy Top left y position of area to be repainted.
    @param cw Width of area to be repainted.
    @param ch Height of area to be repainted.
  */
  virtual void drawContents(QPainter* p, int cx, int cy, int cw, int ch);

private:
  KXStitchDoc*  m_doc;
  QRect         m_visible;
  QPoint        m_point;
  bool          m_moved;
};

#endif
