/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef XSTITCHVIEW_H
#define XSTITCHVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qsplitter.h>

class KXStitchDoc;
class EditView;
class PaletteView;
class PreView;
class KPrinter;

/** The KXStitchView class provides the view widget for the KXStitchApp instance.
    The View instance inherits QSplitter as a base class and represents the view object of a KTMainWindow. As KXStitchView is part of the
    docuement-view model, it needs a reference to the document object connected with it by the KXStitchApp class to manipulate and display
    the document structure provided by the KXStitchDoc class.
    @author Stephen P. Allewell
  */
class KXStitchView : public QSplitter
{
  Q_OBJECT
public:
/** Constructor
  */
  KXStitchView(QWidget *parent = 0, const char *name=0);
/** Descructor
  */
  virtual ~KXStitchView();
/** reset the view parameters to the users preferences
  */
  void configure();

/** Returns a pointer to the document connected to the view instance.
    Mind that this method requires a KXStitchApp instance as a
    parent widget to get to the window document pointer by calling
    the KXStitchApp::getDocument() method.
  */
  KXStitchDoc *getDocument() const;

/** Contains the implementation for printing
    @param printer Pointer to the KPrinter object to be used.
  */
  void print(KPrinter* printer);
  void resetView();

  EditView*     m_editor;
  PreView*      m_preview;
  PaletteView*  m_palette;
};

#endif // XSTITCHVIEW_H
