/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qcursor.h>
#include <kdebug.h>
#include "alphaselect.h"

AlphaSelect::AlphaSelect(QLabel* parent)
  : QLabel(parent)
{
  resize(parent->size());
	setAlignment(Qt::AlignHCenter|Qt::AlignVCenter);
  setPixmap(*(parent->pixmap()));
  setCursor(QCursor(CrossCursor));
}

void AlphaSelect::mousePressEvent(QMouseEvent*)
{
  kdDebug() << "in AlphaSelect::contentsMousePressEvent()" << endl;
}

void AlphaSelect::mouseReleaseEvent(QMouseEvent* e)
{
  kdDebug() << "in AlphaSelect::contentsMouseReleaseEvent()" << endl;
  kdDebug() << "mouse position X:" << e->x() << " Y:" << e->y() << endl;
  emit clicked(e->pos());
}

