/***************************************************************************
*   Copyright (C) 2006 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#include "enterxauthinteractivepasscodedialog.h"
#include <qdialog.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qdialog.h>
#include "enterxauthinteractivepasscodedialog.moc"

EnterXauthInteractivePasscodeDialog::EnterXauthInteractivePasscodeDialog( QWidget *parent, const QString& caption ) : KDialogBase( parent, "Enter Xauth interactive passcode", true, caption,
        KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, true ) {
	Password = "";

	main = new EnterXauthInteractivePasscodeDialogBase( this );
	setMainWidget( main );
	main->setMinimumSize( main->sizeHint() );
}

EnterXauthInteractivePasscodeDialog::~ EnterXauthInteractivePasscodeDialog() {
	delete main;
}


void EnterXauthInteractivePasscodeDialog::accept() {
	bool ok = true;
	if ( main->PasswordEdit->text().isEmpty() ) {
		KMessageBox::sorry( 0, i18n( "Passcode must be filled in!" ) );
		ok = false;
	}

	if ( ok ) {
		Password = main->PasswordEdit->text();
		QDialog::accept();
	}
}
