// =============================================================================
//
//      --- kvi_options_irc.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsIrc"

#include <qlayout.h>

#include "kvi_boolselector.h"
#include "kvi_integerselector.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_options_irc.h"

/*
	@quickhelp: KviOptionsIrc
	@widget: Miscellaneous IRC options
		<h2>Audio Notification</h2>
		A few enhancements to make conversation easier when multi-tasking at or
		away from the desktop, by allowing you to select that certain users will
		cause a beep to be sounded if they type something to you and the window
		is hidden.<br><br>
		<b>Enable Beeping</b>&nbsp;Globally enables/disables whether any event
		will cause an audio alert to be generated, whilst preserving any individual settings.<br>
		<b>Beep on new query opened</b>&nbsp;Causes an audio alert to be sounded
		if a query box is opended from a /msg, regardless of whether the remote user
		is in the registered users database or not. Also works for DCC chat sessions.<br>
		<b>Make beep setting persistant</b>&nbsp;If this option is selected, the
		registered users database is used to hold a record of beep options for all users,
		even if you had not previously entered that user. This is handy, as it provides
		persistant beep settings across multiple sessions. It has the downside that it
		could clutter up your user database if you do not turn beeping off on a user
		before you finish talking to them (though you could always hand delete later).<br>
		If you <em>do</em> turn this feature on, KVIrc will forget who you want to have
		beep unless they are already in the database for another reason.<br>
*/
KviOptionsIrc::KviOptionsIrc(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_IRCMISC)
{
	QGridLayout *g = new QGridLayout(this, 20, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, 1);

	KviBoolSelector *b = new KviBoolSelector(this, _i18n_("Force 'brutal' quit"), &(g_pOptions->m_bBrutalQuit));
	g->addWidget(b, 0, 0);

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f, 1, 0);

	b = new KviBoolSelector(this, _i18n_("Automatically rejoin channels when kicked"), &(g_pOptions->m_bAutoRejoinOnKick));
	g->addWidget(b, 2, 0);
	b = new KviBoolSelector(this, _i18n_("Dump channel status to file when kicked"), &(g_pOptions->m_bDumpChannelOnKick));
	g->addWidget(b, 3, 0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f, 4, 0);

	b = new KviBoolSelector(this,
		_i18n_("Automatically join channels when invited"), &(g_pOptions->m_bAutoJoinChanOnInvite)
	);
	g->addWidget(b, 5, 0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f, 6, 0);

	b = new KviBoolSelector(this,
		_i18n_("Request ban and invite exception lists on join"), &(g_pOptions->m_bRequestBanExceptionListOnJoin)
	);
	g->addWidget(b, 7, 0);
	b = new KviBoolSelector(this,
		_i18n_("Request who list after end of names list"), &(g_pOptions->m_bRequestWhoAfterEndOfNames)
	);
	g->addWidget(b, 8, 0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f, 9, 0);

	b = new KviBoolSelector(this,
		_i18n_("Disable updates to the internal userlist"), &(g_pOptions->m_bDisableUpdateUserList)
	);
	g->addWidget(b, 10, 0);

	KviIntegerSelector *i = new KviIntegerSelector(this,
		_i18n_("Userlist update interval:"),
		&(g_pOptions->m_iUserListUpdateTimeoutInSecs), KviIntegerSelector::Int, 1, 65535, 10,
		true, 100, 0, _i18n_(" second(s)")
	);
	g->addWidget(i, 11, 0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f, 12, 0);

	b = new KviBoolSelector(this, _i18n_("Enable beeping"), &(g_pOptions->m_bEnableBeeping));
	g->addWidget(b, 13, 0);

	b = new KviBoolSelector(this, _i18n_("Beep on new query/DCC chat"), &(g_pOptions->m_bBeepOnNewQuery));
	g->addWidget(b, 14, 0);

	b = new KviBoolSelector(this, _i18n_("Make beep setting persistant"), &(g_pOptions->m_bAddUsersForBeepControl));
	g->addWidget(b, 15, 0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f, 16, 0);

	i = new KviIntegerSelector(this,
		_i18n_("Length of inactivity after OnIdleStart event is triggered:"),
		&(g_pOptions->m_iOnIdleAfter), KviIntegerSelector::Int, 20, 65535, 10, true, 100, 0,
		_i18n_(" second(s)")
	);
	g->addWidget(i, 17, 0);

	b = new KviBoolSelector(this,
		_i18n_("Trigger OnIdleStop event even on command input"), &(g_pOptions->m_bCancelIdleOnAnyInput)
	);
	g->addWidget(b, 18, 0);

	f = new QFrame(this);
	g->addWidget(f, 19, 0);
	g->setRowStretch(19, 1);
}

KviOptionsIrc::~KviOptionsIrc()
{
	// Nothing here
}

void KviOptionsIrc::commitChanges()
{
	KviBoolSelector::commitAll(this);
	KviIntegerSelector::commitAll(this);
}

#include "m_kvi_options_irc.moc"
