#ifndef _KVI_USERTOOLBAR_H_INCLUDED_
#define _KVI_USERTOOLBAR_H_INCLUDED_

// =============================================================================
//
//      --- kvi_usertoolbar.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_string.h"
#include "kvi_toolbar.h"

class KviFrame;
class KviUserPopupMenu;
class KviUserToolBarTemplate;
class KviUserToolButton;

typedef struct KviUserToolBarData
{
	KviStr             buffer;
	KviStr             image;
	KviStr             text;
	KviStr             sbar;
	KviUserToolButton *button;
	KviUserPopupMenu  *menu;
	int                id;
	int                type;
};

/**
 * An item with id = 0, menu = 0 and buffer = " " is a separator.
 * Normal menu item buffers have the initial spaces stripped at
 * insertion time.
 */
class KviUserToolBar : public KviToolBar
{
	friend class KviDlgScript;

	Q_OBJECT
public:
	KviUserToolBar(KviFrame *frame, Qt::Dock dock = Qt::DockTop);
	KviUserToolBar(KviFrame *frame, QWidget *parent, Qt::Dock dock = Qt::DockTop);

	~KviUserToolBar();

	enum ToolButtonType { Separator, Button, Menu };
	QPtrList<KviUserToolBarData> *m_pDataList;

	bool m_bLocked; // Protects against self-modification
	void clearAll();
	int  insertNormalItem(
		const char *name, const char *sbar, const char *img, const char *buffer, KviUserPopupMenu *menu = 0
	);
	void insertSeparatorItem();
	void copyFromTemplate(KviUserToolBarTemplate *toolbar, bool bEditPopup = true);
	void clearToolBar();
	bool isEmpty();
public slots:
	void buttonClicked(int id);
protected slots:
	void popupClicked(const KviStr &dataBuffer);
private:
	KviFrame *m_pFrame;
	QWidget  *m_pParent;
	int       m_id;

	void initialize(KviFrame *, QWidget *);
};


#endif // _KVI_USERTOOLBAR_H_INCLUDED_
