#ifndef _KVI_FONTSELECTOR_H_INCLUDED_
#define _KVI_FONTSELECTOR_H_INCLUDED_

// =============================================================================
//
//      --- kvi_fontselector.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qwidget.h>

class KviFontButton;
class KviLabel;

class KviFontSelector : public QWidget
{
	Q_OBJECT
public:
	KviFontSelector(QWidget *parent, const char *label, QFont *fnt, bool bEnabled = true, int defInputWidth = 100);
	~KviFontSelector();
private:
	QFont         *m_valuePtr;
	KviLabel      *m_pLabel;
	KviFontButton *m_pFntButton;
	int m_iDefInputWidth;
protected:
	virtual void resizeEvent(QResizeEvent *);
public:
	virtual QSize sizeHint();
	QFont getFont();
	void commitChanges();
};

#endif // _KVI_FONTSELECTOR_H_INCLUDED_
