/***************************************************************************
 *   Copyright (C) 2001-2006 by Michael Herder (crapsite@gmx.net)          *
 *   and Raul Fernandes (rgfbr@yahoo.com.br)                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
                          qocrprogress.cpp  -  description
                             -------------------
    begin                : Tue Jan 16 2001
    copyright            : (C) 2001 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/


#include "qocrprogress.h"

#include <qfile.h>
#include <qimage.h>
#include <qnamespace.h>
#include <qtextstream.h>
#include <qregexp.h>

#include <ktempfile.h>
#include <kinputdialog.h>
#include <klocale.h>

#ifndef NDEBUG

#include <kdebug.h>

#endif


QOCRProgress::QOCRProgress(QObject *parent)
             :QObject(parent)
{
   tempImageFile=0L;
   m_process=0L;
   unrecognized_characters=false;
   setDustSize(10);
   setGreyLimit(160);
}

QOCRProgress::~QOCRProgress()
{
  if (tempImageFile)
     delete tempImageFile;
  if (m_process)
     delete m_process;
}

/** No descriptions */
void QOCRProgress::start(QImage image)
{
  if (m_process) {

   #ifndef NDEBUG

     kdDebug()<<"Ocr process still runnning, I do not accept a new image right now."<<endl;

   #endif

     return;
  }

  if (tempImageFile) {
     delete tempImageFile;
     tempImageFile = 0L;
  }

  tempImageFile=new KTempFile(QString::null,".pnm");
  tempImageFile->setAutoDelete(true);
  image.save(tempImageFile->name(),"PPM");

  startOCR();
}

void QOCRProgress::startOCR()
{
/*  if (!tempImageFile) {
     kdDebug()<<"Have no image, cannot ocr."<<endl;
     return;
  }*/
  unrecognized_characters=false;
  m_ocrText=QString::null;
  m_process = new KProcIO();
  connect(m_process,SIGNAL(processExited(KProcess *)),
          this,SLOT(slotProcessExited()));
  connect(m_process,SIGNAL(readReady(KProcIO *)),
          this,SLOT(slotReadStdout()));

  //don't know if this works for procio.
  //connect(m_process,SIGNAL(receivedStderr(KProcess *, char *, int )),
    //      this,SLOT(slotReceivedStderr(KProcess *, char *, int )));

  (*m_process)<<"gocr";
  (*m_process)<<"-l"<<( (m_greyLimit>0 && m_greyLimit<255) ? QString::number(m_greyLimit) : "160")
         <<"-d"<< (m_dustSize>=0 ? QString::number(m_dustSize) : "10")
         <<"-i"<<tempImageFile->name();
  if(!m_process->start(KProcess::NotifyOnExit,false))
  {
  #ifndef NDEBUG

    kdError()<<"Could not start gocr process. Possible reasons:\n" << "  1) gocr is not in your PATH  2) I could not fork"<<endl;

  #endif

    delete m_process;
    m_process = 0L;
  }
}


/**  */
void QOCRProgress::slotProcessExited()
{
  if(!m_process) return;
  if(m_process->normalExit())
  {
    if(!m_process->exitStatus())
    {
       bool ok=true;
       if (unrecognized_characters) {
          m_ocrText=KInputDialog::getText(i18n("Unrecognized Characters"),
               i18n("The text could not fully be recognized.\nPlease check it yourself."),m_ocrText,&ok);
       } else if (m_ocrText.isEmpty()) { //the same code can be found in ocrplugin.cpp
                                         //  to handle the case that no boxes are found.
          m_ocrText=KInputDialog::getText(i18n("No Text Found"),
               i18n("No text could be found in the region you clicked on.\nDo you want to type it?"),m_ocrText,&ok);
       }
       if (ok)
          emit finishedOCR(m_ocrText);
    }
  }
  delete m_process;
  m_process = 0L;
}


/**  */
void QOCRProgress::slotReadStdout()
{
  if(m_process)
  {
     QString temp;
     m_process->readln(temp);
     if (temp.contains('_')) //gocr's signal for unrecognized
         unrecognized_characters=true;
     temp.replace(QRegExp("\\W"),""); // '_' stands for unrecognized character
     m_ocrText+=temp;                 //     and it is also better to remove all non-word characters
  }
}
/** */
void QOCRProgress::slotReceivedStderr(KProcess *, char *buffer, int buflen)
{
  if(m_process)
  {
    QString qs((QChar *)buffer,buflen);
  #ifndef NDEBUG

    kdDebug()<<"gocr errors: "<<qs<<endl;

  #endif
  }
}

/*QString QOCRProgress::ocrText()
{
  return mOcrText;
}*/


/** Write property of int m_dustSize. */
void QOCRProgress::setDustSize( const int& _newVal){
	m_dustSize = _newVal;
}
/** Write property of int m_greyLimit. */
void QOCRProgress::setGreyLimit( const int& _newVal){
	m_greyLimit = _newVal;
}

#include "qocrprogress.moc"
