/***************************************************************************
 *   Copyright (C) 2002-2006 by                                            *
 *   Marcel Wiesweg (marcel@wiesweg-online.de)                             *
 *   and Raul Fernandes (rgfbr@yahoo.com.br)                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
                          ocrwatchdog.h  -  description
                             -------------------
    begin                : Mit Jul 24 2002
    copyright            : (C) 2002 by Marcel Wiesweg
    email                : marcel@wiesweg-online.de
 ***************************************************************************/


#ifndef OCRWATCHDOG_H
#define OCRWATCHDOG_H

#include <qwidget.h>
#include <qpixmap.h>
#include <kshortcut.h>
#include <qmap.h>

/**When the configured combination of mouse click and key press occurs, the class grabs the area and emits a signal.
  *@author Marcel Wiesweg
  */

class OcrWatchdog : public QWidget/*, public DCOPObject*/  {
   Q_OBJECT
   //K_DCOP
public:
  OcrWatchdog(QWidget *parent=0, const char *name=0);
  ~OcrWatchdog();
  void deactivate();
  void activate();
  void loadModifierKey();
public slots: // Public slots
  /** No descriptions */
  bool x11Event( XEvent * );

protected slots: // Protected slots
  /** Performs grabbing */
  void clickOccured();
signals: //signals
  void gotIt(QPixmap pixmap,int xOfPoint,int yOfPoint);
protected:
  int button;
};

#endif
