/***************************************************************************
                          rigctrl.cpp  -  description
                             -------------------
    begin                : Sun Sep 8 2002
    copyright            : (C) 2002 by Luc Langehegermann
    email                : lx2gt@qsl.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rigctrl.h"

#include <qtimer.h>

rigctrl::rigctrl(QObject *parent, const char *name ) : QObject(parent,name) {
  azcorrection=0;
  elcorrection=0;
  correction=0;
  wrapper = new hamlibWrapper();
  currentSatellite=NULL;
  currentTransponder=NULL;
  currentCorrection=0;
  counter=0;
  currentUplinkFreq=145000000;
  currentDownlinkFreq=435000000;
//  downlinkDisabled=false;
  oldtrxfreq=0;
//  downlinkDisabled=true;
  // timer for polling the rig!
  QTimer* timer = new QTimer(this);
  QObject::connect(timer, SIGNAL(timeout()), this, SLOT(slotTimeout()));
  timer->start(1);
}
rigctrl::~rigctrl(){
  delete wrapper;
}
/** No descriptions */
int rigctrl::open(s_hardware* hardware){
  azcorrection=hardware->azimuthCorrection;
  elcorrection=hardware->elevationCorrection;
  int retval;

  if (hardware->downlinkreceiver)
    retval = wrapper->init(hardware->drig.radio, hardware->drig.port, hardware->drig.speed,
                           hardware->urig.radio, hardware->urig.port, hardware->urig.speed);
  else
    retval = wrapper->init(hardware->urig.radio, hardware->urig.port, hardware->urig.speed);

  if (retval) return retval;
  else {
    retval = wrapper->initRotor(hardware->rotorinterface.rotor, hardware->rotorinterface.port, hardware->rotorinterface.speed, hardware->rotor450);
    return retval;
  }
}
/** No descriptions */
void rigctrl::setSatellite(satellite* s){
  currentSatellite=s;
}
/** No descriptions */
void rigctrl::setTransponder(transponder* t){
  rmode_t hamlibumode, hamlibdmode;
  hamlibumode=RIG_MODE_USB;
  hamlibdmode=RIG_MODE_USB;

  currentTransponder=t;
  wrapper->setPreamp(t->preamp());
  currentUplinkFreq=t->uplink();
  currentDownlinkFreq=t->downlink();
  setFreqs(true);
  if (t->reverse() && t->mode() == MODE_SSB) {
    hamlibumode=RIG_MODE_LSB;
    hamlibdmode=RIG_MODE_USB;
  }
  if (!t->reverse() && t->mode() == MODE_SSB) {
    hamlibumode=RIG_MODE_USB;
    hamlibdmode=RIG_MODE_USB;
  }
  if (t->mode() == MODE_FM) {
    hamlibumode=RIG_MODE_FM;
    hamlibdmode=RIG_MODE_FM;
  }
  if (t->mode() == MODE_CW) {
    hamlibumode=RIG_MODE_CW;
    hamlibdmode=RIG_MODE_CW;
  }
  wrapper->setModes(hamlibdmode, hamlibumode);
}
/** No descriptions */
void rigctrl::setCorrection(int corr){
  correction=corr;
}
/** gets called when a new calculation is done */
void rigctrl::slotTimeout(){
  // calculate the current satellite for doppler correction!
  if (currentSatellite) currentSatellite->propagator->calc();
  if (!currentTransponder) return;
  long long freq;
  freq = wrapper->getDownlinkFrequency();
  // find out if we have a new trx frequency
  if (!wrapper->userChangedFreq()/* || !downlinkDisabled*/) {
    freq = freq + currentTransponder->downdiff();
    // remove doppler
    currentDownlinkFreq = freq - currentSatellite->doppler(freq);
  }
  setFreqs(false);
  emit (newDownlinkFreq((unsigned long long)currentDownlinkFreq));

  if (currentTransponder->uplink())
    emit (newUplinkFreq((unsigned long long)currentUplinkFreq+correction));
}
/** No descriptions */
//void rigctrl::slotDisableDownlink(bool i){
//  downlinkDisabled=i;
//}
/** No descriptions */
void rigctrl::setFreqs(bool now){
  double utrxfreq, dtrxfreq;
  // calculate a new currentuplink
  double diff = currentTransponder->downlink() - currentDownlinkFreq;
  if (currentTransponder->reverse())
    currentUplinkFreq = currentTransponder->uplink() + diff;
  else
    currentUplinkFreq = currentTransponder->uplink() - diff;
  
  // get the trx frequencies

  utrxfreq = currentUplinkFreq + correction;
  utrxfreq = utrxfreq - currentSatellite->doppler((unsigned long long)utrxfreq);
  utrxfreq = utrxfreq - currentTransponder->updiff();

// Hmm... why was this this way around here?

//  if (/*downlinkDisabled || */now)
    dtrxfreq = currentDownlinkFreq + currentSatellite->doppler((unsigned long long)currentDownlinkFreq);
//  else
//    dtrxfreq = 0;
  dtrxfreq = dtrxfreq - currentTransponder->downdiff();

  if (currentTransponder->uplink() == 0) utrxfreq=0;

  wrapper->setFreqs((unsigned long long)dtrxfreq, (unsigned long long)utrxfreq, now);
  oldtrxfreq=(unsigned long long)dtrxfreq;
}
/** No descriptions */
void rigctrl::slotSetPause(bool p){
  wrapper->setPause(p);
}
/** No descriptions */
void rigctrl::setDirection(float el, float az){
  float azimuth, elevation;
  azimuth = az + azcorrection;
  elevation = el + elcorrection;

  if (elevation < 0) elevation = 0;
  if (elevation > 180) elevation = 180;

  if (azimuth >= 360.0) azimuth = azimuth - 360.0;
  if (azimuth < 0.0) azimuth = azimuth + 360.0;
  
  wrapper->setDirection(azimuth, elevation);
}
