/***************************************************************************
 *   Copyright (C) 2003 by Tom Deblauwe                                    *
 *   tomNOSPAM.deblauwe@pandora.be                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef KSUBTILEPLAYER_H
#define KSUBTILEPLAYER_H

#include <qwidget.h>
#include <ksubtileplayerdlg.h>
#include "kprocess.h"
#include "kwinmodule.h"
#include "ksubtile.h"
#include "ksubtileview.h"
#include "csubtitle.h"
#include "qdatetime.h"

class KSubtileView;

/**
@author Tom Deblauwe
*/
class KSubtilePlayer : public KSubtilePlayerDlg
{
Q_OBJECT
public:

  public:
    /** Constructor for the main view */
    KSubtilePlayer(QWidget *parent = 0, const char *name=0);

    ~KSubtilePlayer();

    /** If a movie was invoked with the player, you can stop it with this
      * function
      */
    void stopPlayingMovie(void);

    void checkEnableWithSubtitles(void);

    //enable the play buttons on the player
    void player_enable();

    //make this public because the import function calls this in KsubtileApp in slotFileImport()
    virtual void pb_player_open_clicked( void );

    virtual void pb_player_play_clicked(void);

    long getPlayerCurrentPos(void);
    long getPlayerMovieLength(void);
    
    //open a movie
    void openMovie(const QString& filename);
	
    //emitted when a movie is succesfull loaded
  signals:
    void movieLoaded(QString filename);

  private slots:
    void slotPlayerPlayingFinished(KProcess*);
    void slotReceivedStdout(KProcess*,char*,int);
	void slotReceivedStderr(KProcess*,char*,int);
	
    void slotMPlayerWid( WId wid );

    void slotLengthReceivedStdout(KProcess*,char*,int);
    void slotLengthPlayingFinished(KProcess*);

  private:

    virtual void pb_player_pause_clicked(void);
    virtual void pb_player_stop_clicked(void);
    virtual void pb_player_backward_clicked(void);
    virtual void pb_player_forward_clicked(void);

    virtual void sl_player_currentPosition_sliderPressed(void);
    virtual void sl_player_currentPosition_sliderReleased(void);
    virtual void sl_player_currentPosition_sliderMoved(int);
    virtual void te_player_startTime_valueChanged(const QTime &);

    //controls wether the slider should follow the mplayer process or not
    bool b_slider_follow_mplayer;

    //see the valuechanged function and the slidermoved function
    bool b_enable_player_startTime_valueChanged;

    /*   the process containing mplayer playing */
    KProcess* proc;

    /* The current position of MPlayer in the movie */
    long playerCurrentPos;

    //the movie's length
    long playerMovieLength;

    //the movie's height and width
    int playerMovieWidth;
    int playerMovieHeight;

    //the process to check the length of a movie
    KProcess* procLength;

    QString fileNameOfCheckedMovie;

    /*   to connect to, to make the mplayer window always on top   */
    KWinModule* kwm;

    //returns a pointer to the editor
    KSubtileView* getEditor(void);

};

#endif
