/***************************************************************************
                          filterdialog.cpp  -  description
                             -------------------
    begin                : Die Sep 23 2003
    copyright            : (C) 2003 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qradiobutton.h>
#include <qcombobox.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kdebug.h>
 
#include "filterdialog.h"
#include "filterentrydialog.h"

FilterDialog::FilterDialog(QWidget *parent, const char *name ) :
  FilterDlg(parent,name)
{
  switch (Filter::_status)
  {
    case Filter::off:
      _radioOff->setChecked(true);
      break;
    case Filter::on:
      _radioOn->setChecked(true);
      break;
    case Filter::automatic:
      _radioAuto->setChecked(true);
      break;
  }
  _filters = Filter::_filter;
  _filters.setCombo(_comboFilter, 0);
}

FilterDialog::~FilterDialog()
{
}

void FilterDialog::slotFilterActivated (int index)
{
  _filters.at (index);
}

void FilterDialog::slotAdd ()
{
	FilterElem* entry = new FilterElem ();
	FilterEntryDialog dlg (this, "New filter", entry);
	if (dlg.exec () == QDialog::Accepted)
	{
		_filters.inSort (entry);
		int pos = _filters.at ();
    _filters.setCombo(_comboFilter, pos);
  }
	else
		delete entry;
}

void FilterDialog::slotEdit ()
{
	if (_filters.current ())
	{
		FilterEntryDialog dlg (this, "Edit command", _filters.current ());
		if (dlg.exec () == QDialog::Accepted)
		{
			// the command name may have changed. Update the combo box.
      _filters.sort();
      int pos = _filters.at ();
      _filters.setCombo(_comboFilter, pos);
		}
	}
}

void FilterDialog::slotCopy ()
{
	if (_filters.current ())
	{
		FilterElem* entry = new FilterElem (*_filters.current ());
		FilterEntryDialog dlg (this, "Copy command", entry);
		if (dlg.exec () == QDialog::Accepted)
		{
			_filters.inSort (entry);
			int pos = _filters.at ();
      _filters.setCombo(_comboFilter, pos);
		}
		else
			delete entry;
	}
}

void FilterDialog::slotDelete ()
{
	if (_filters.current())
	{
		if (KMessageBox::warningYesNo (this, i18n("Filter %1 will be deleted.\n"
                                              "Are you sure ?").arg(_filters.current()->toString())) == KMessageBox::Yes)
		{
			int pos = _filters.at ();
			_filters.remove (pos);
      _filters.setCombo(_comboFilter, pos);
		}
	}
}

void FilterDialog::slotOk ()
{
  if (_radioOff->isChecked())
    Filter::_status = Filter::off;
  else if (_radioOn->isChecked())
    Filter::_status = Filter::on;
  else if (_radioAuto->isChecked())
    Filter::_status = Filter::automatic;
  else
    Filter::_status = Filter::off;
  
  Filter::_filter = _filters;
  accept ();
}

void FilterDialog::slotAutomaticActivated ()
{
  if (_radioAuto->isChecked())
  {
    if (KMessageBox::warningContinueCancel (this, i18n("Automatic filters can cause loss of important mails.\n"
                                                       "Please test your filters.\n"
                                                       "Are you sure ?"),
                                                       QString::null,
                                                       KStdGuiItem::cont(),
                                                       "autofilteraskagain") == KMessageBox::Cancel)
      _radioOn->setChecked (true);
  }
}

