/***************************************************************************
                          filter.cpp  -  description
                             -------------------
    begin                : Die Sep 23 2003
    copyright            : (C) 2003 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filter.h"

FilterList Filter::_filter;
Filter::filterStatus Filter::_status = Filter::off;

Filter::Filter()
{
}

Filter::~Filter()
{
}

FilterElem* Filter::matches (ShowRecordElem* pElem)
{
  for (FilterElem* pFilter = _filter.first(); pFilter; pFilter = _filter.next())
  {
    if (pFilter->matches (pElem))
      return pFilter;
  }
  return NULL;
}

void Filter::readOptions (KConfig* config)
{
  config->setGroup ("filter_general");
  _status = (Filter::filterStatus)config->readNumEntry("status", 0);
  _filter.readOptions(config);
}

void Filter::saveOptions (KConfig* config)
{
  config->setGroup ("filter_general");
  config->writeEntry ("status", _status);
  _filter.saveOptions(config);
  config->sync();
}
