# regression tests for the pax utility

export ERROR_OPTIONS=nosystem TZ=EST5EDT

umask 0

chmod 755 .

formats='binary-cpio cpio asc aschk pax oldtar tar'

dateformat='%(mtime:time=%Y-%m-%d/%H:%M:%S)s %(path)s'
modeformat='%(mtime:time=%K)s %(mode)s %(mode:case:-*:%(size)u:*:0)s %(path)s'
testformat='%(mtime:time=%K)s %(mode)s %(mode:case:-*:%(size)u:*:0)8s %(path)s%(linkop:case:?*: %(linkop)s %(linkpath)s)s'

VIEW data

KEEP 't.?'

function DATA
{
	for i
	do	test -f $i ||
		case $i in
		b1)	print $'0123456789' > $i
			touch -t 2000-01-02+03:04:05 $i
			chmod 644 $i
			;;
		b2)	print $'ab' > $i
			touch -t 2005-04-03+02:01:00 $i
			chmod 644 $i
			;;
		a1)	print $'append' > $i
			touch -t 2005-06-07+08:09:10 $i
			chmod 644 $i
			;;
		t.c1)	print $'method=md5
permissions
168805c362787f61c79f9a52d6ee8fc0 0644 - - t.r
2cd322e2bee9b35c7a4c2595e5593330 4700 - - t.s
74d9a83219cabaab06a69fd318873f33 0755 - - t.x' > $i
			;;
		t.c2)	print $'method=md5
permissions
6105347ebb9825ac754615ca55ff3b0c 0644 - - t.n
6105347ebb9825ac754615ca55ff3b0c 0644 - - t.r
6105347ebb9825ac754615ca55ff3b0c 4700 - - t.s' > $i
			;;
		t.c3)	print $'method=md5
permissions
7389db8ac880351b920e55906980a570 0644 - - t.n
8880cd8c1fb402585779766f681b868b 0644 - - t.r
4d50db1dc6bd8d4f8dc1ca9b83bdc187 4700 - - t.s' > $i
			;;
		t.c4)	print $'method=md5
permissions
7389db8ac880351b920e55906980a570 0644 - - fn.dat
6105347ebb9825ac754615ca55ff3b0c 0644 - - fr.dat
2cd322e2bee9b35c7a4c2595e5593330 4700 - - t.s' > $i
			;;
		t.i)	print $'chmod 4700 t.s' > $i
			;;
		t.n)	echo ' 000 ' > $i
			chmod 644 $i
			;;
		t.r)	echo ' hit ' > $i
			chmod 644 $i
			;;
		t.s)	echo ' HIT ' > $i
			chmod 4700 $i
			;;
		t.x)	echo true > $i
			chmod 755 $i
			;;
		esac
	done
}

TEST 01 'basics'

	EXEC --nosummary --listformat="$testformat" -vf $data/aha.dat
		OUTPUT - $'2003-09-17+10:55:27 -rw-r--r--        4 aha'

	EXEC --nosummary --listformat="$testformat" -v
		SAME INPUT $data/aha.dat

	EXEC --nosummary --from=ascii -rvf $data/aha.dat
		OUTPUT -
		OUTPUT aha $'aha'
		ERROR - $'aha'

	EXEC --nosummary -x pax -wvf t.pax -o 'uid:=010000000 gid:=07777777' aha

	EXEC --nosummary -vf t.pax --listformat='%(uid)d %(gid)d %(path)s'
		OUTPUT - $'10000000 7777777 aha'
		ERROR -

	EXEC --nosummary -x pax -wvf t.pax -o 'uname=bozo gname=bigtop' aha
		OUTPUT -
		ERROR - $'aha'

	EXEC --nosummary -vf t.pax --listformat='%(uname)s %(gname)s %(path)s'
		OUTPUT - $'bozo bigtop aha'
		ERROR -

	EXEC --nosummary -x pax -wvf t.pax -o 'uname=bozo uid:=010000000 gname=bigtop gid:=07777777' aha
		OUTPUT -
		ERROR - $'aha'

	EXEC --nosummary -vf t.pax --listformat='%(uname)s/%(uid)d %(gname)s/%(gid)d %(path)s'
		OUTPUT - $'bozo/10000000 bigtop/7777777 aha'
		ERROR -

TEST 02 'archive format conversion'

	EXEC --nosummary --from=ascii -rf $data/y2k.dat list.dat

	EXEC --listformat="$dateformat" -vf $data/y2k.dat
		SAME OUTPUT list.dat
		ERROR - $data/y2k.dat $'in gzip cpio format\n372 files, 99 blocks'

	EXEC -rf $data/y2k.dat -wf y2k.pax -x asc
		OUTPUT -
		ERROR - '116 blocks'

	EXEC --listformat="$dateformat" -vf y2k.pax
		SAME OUTPUT list.dat
		ERROR - y2k.pax $'in asc format\n372 files, 116 blocks'

	EXEC -rf $data/y2k.dat -wf y2k.pax -x aschk
		OUTPUT -
		ERROR - '116 blocks'

	EXEC --listformat="$dateformat" -vf y2k.pax
		SAME OUTPUT list.dat
		ERROR - y2k.pax $'in aschk format\n372 files, 116 blocks'

	EXEC -rf $data/y2k.dat -wf y2k.pax -x binary
		OUTPUT -
		ERROR - '54 blocks'

	EXEC --listformat="$dateformat" -vf y2k.pax
		SAME OUTPUT list.dat
		ERROR - y2k.pax $'in binary format\n372 files, 54 blocks'

	EXEC -rf $data/y2k.dat -wf y2k.pax -x cpio
		OUTPUT -
		ERROR - '99 blocks'

	EXEC --listformat="$dateformat" -vf y2k.pax
		SAME OUTPUT list.dat
		ERROR - y2k.pax $'in cpio format\n372 files, 99 blocks'

	EXEC --comment=force-pax -rf $data/y2k.dat -wf y2k.pax -x pax
		OUTPUT -
		ERROR - '401 blocks'

	EXEC --listformat="$dateformat" -vf y2k.pax
		SAME OUTPUT list.dat
		ERROR - y2k.pax $'in pax format\n372 files, 401 blocks'

	EXEC -rf $data/y2k.dat -wf y2k.pax -x oldtar
		OUTPUT -
		ERROR - '399 blocks'

	EXEC --listformat="$dateformat" -vf y2k.pax
		SAME OUTPUT list.dat
		ERROR - y2k.pax $'in oldtar format\n372 files, 399 blocks'

	EXEC -rf $data/y2k.dat -wf y2k.pax -x ustar
		OUTPUT -
		ERROR - '399 blocks'

	EXEC --listformat="$dateformat" -vf y2k.pax
		SAME OUTPUT list.dat
		ERROR - y2k.pax $'in ustar format\n372 files, 399 blocks'

	EXEC -rf $data/y2k.dat -wf y2k.pax -x vdb
		OUTPUT -
		ERROR - '69 blocks'

	EXEC --listformat="$dateformat" -vf y2k.pax
		SAME OUTPUT list.dat
		ERROR - y2k.pax $'in vdb format\n372 files, 69 blocks'

TEST 03 'different file modes'
	o=

	EXEC --nosummary $o --from=ascii -rf $data/mode.dat keep.lst mode.lst
		OUTPUT -
		ERROR -

	EXEC --listformat="$modeformat" --from=ascii -vf $data/mode.dat
		SAME OUTPUT keep.lst
		ERROR - $data/mode.dat $'in gzip cpio format\n19 files, 8 blocks'

	EXEC --nosummary $o --from=ascii -rf $data/mode.dat
		OUTPUT -
		ERROR - $'pax: warning: mode.dir/m4000: mode --S------ not set
pax: warning: mode.dir/m4100: mode --S------ not set
pax: warning: mode.dir/m4200: mode --S------ not set
pax: warning: mode.dir/m4300: mode --S------ not set
pax: warning: mode.dir/m4400: mode --S------ not set
pax: warning: mode.dir/m4500: mode --S------ not set
pax: warning: mode.dir/m4600: mode --S------ not set
pax: warning: mode.dir/m4700: mode --S------ not set'

	EXEC --nosummary -wf mode.pax keep.lst mode.lst mode.dir
		ERROR -

	EXEC --listformat="$modeformat" -vf mode.pax
		SAME OUTPUT mode.lst
		ERROR - mode.pax $'in pax format\n19 files, 35 blocks'

	EXEC --nosummary $o --from=ascii -rf $data/mode.dat
		OUTPUT -
		ERROR - $'pax: warning: mode.dir/m4000: mode --S------ not set
pax: warning: mode.dir/m4100: mode --S------ not set
pax: warning: mode.dir/m4200: mode --S------ not set
pax: warning: mode.dir/m4300: mode --S------ not set
pax: warning: mode.dir/m4400: mode --S------ not set
pax: warning: mode.dir/m4500: mode --S------ not set
pax: warning: mode.dir/m4600: mode --S------ not set
pax: warning: mode.dir/m4700: mode --S------ not set'

	EXEC --nosummary -wf mode.pax keep.lst mode.lst mode.dir
		ERROR -

	EXEC --listformat="$modeformat" -vf mode.pax
		SAME OUTPUT mode.lst
		ERROR - mode.pax $'in pax format\n19 files, 35 blocks'

	DO chmod u+rw,go+r mode.dir/*

	EXEC --nosummary $o --from=ascii -rf $data/mode.dat
		OUTPUT -
		ERROR - $'pax: warning: mode.dir/m4000: mode --S------ not set
pax: warning: mode.dir/m4100: mode --S------ not set
pax: warning: mode.dir/m4200: mode --S------ not set
pax: warning: mode.dir/m4300: mode --S------ not set
pax: warning: mode.dir/m4400: mode --S------ not set
pax: warning: mode.dir/m4500: mode --S------ not set
pax: warning: mode.dir/m4600: mode --S------ not set
pax: warning: mode.dir/m4700: mode --S------ not set'

	EXEC --nosummary -wf mode.pax keep.lst mode.lst mode.dir
		ERROR -

	EXEC --listformat="$modeformat" -vf mode.pax
		SAME OUTPUT mode.lst
		ERROR - mode.pax $'in pax format\n19 files, 35 blocks'

	o=--preserve=ps


	EXEC --nosummary $o --from=ascii -rf $data/mode.dat keep.lst mode.lst
		OUTPUT -
		ERROR -

	EXEC --listformat="$modeformat" --from=ascii -vf $data/mode.dat
		SAME OUTPUT keep.lst
		ERROR - $data/mode.dat $'in gzip cpio format\n19 files, 8 blocks'

	EXEC --nosummary $o --from=ascii -rf $data/mode.dat
		OUTPUT -
		ERROR -

	EXEC --nosummary -wf mode.pax keep.lst mode.lst mode.dir

	EXEC --listformat="$modeformat" -vf mode.pax
		SAME OUTPUT keep.lst
		ERROR - mode.pax $'in pax format\n19 files, 35 blocks'

	EXEC --nosummary $o --from=ascii -rf $data/mode.dat
		OUTPUT -
		ERROR -

	EXEC --nosummary -wf mode.pax keep.lst mode.lst mode.dir

	EXEC --listformat="$modeformat" -vf mode.pax
		SAME OUTPUT keep.lst
		ERROR - mode.pax $'in pax format\n19 files, 35 blocks'

	DO chmod u+rw,go+r mode.dir/*

	EXEC --nosummary $o --from=ascii -rf $data/mode.dat
		OUTPUT -
		ERROR -

	EXEC --nosummary -wf mode.pax keep.lst mode.lst mode.dir

	EXEC --listformat="$modeformat" -vf mode.pax
		SAME OUTPUT keep.lst
		ERROR - mode.pax $'in pax format\n19 files, 35 blocks'

TEST 04 'file and link path substitution'

	EXEC --nosummary --from=ascii -f $data/link.dat
		OUTPUT - $'bin/aaa
bin/bbb -> bin/aaa
bin/yyy
bin/zzz == bin/yyy'

	EXEC --nosummary -L --from=ascii -f $data/link.dat -s ,^,usr/,
		OUTPUT - $'usr/bin/aaa
usr/bin/bbb -> usr/bin/aaa
usr/bin/yyy
usr/bin/zzz == usr/bin/yyy'

	EXEC --nosummary -P --from=ascii -f $data/link.dat -s ,^,usr/,
		OUTPUT - $'usr/bin/aaa
usr/bin/bbb -> bin/aaa
usr/bin/yyy
usr/bin/zzz == usr/bin/yyy'

TEST 05 'long path test #1 (converted from the star tests for ascii+ebcdic)'

	EXEC --nosummary -f $data/star-long-1.dat
		SAME OUTPUT $data/star-long-1.lst

	EXEC --nosummary -rvf $data/star-long-1.dat
		OUTPUT -
		COPY ERROR star_long_1.v
		ERROR - $'----------------+020
----------------+020/---------------+040
----------------+020/---------------+040/---------------+060
----------------+020/---------------+040/---------------+060/---------------+080
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/--------+153
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/--------+153/--------------------------------------------------------------------------------------------------101
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/--------+153/-------------------------------------------------------------------------------------------------100
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/--------+153/------------------------------------------------------------------------------------------------099
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------+154
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------+154/--------------------------------------------------------------------------------------------------101
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------+154/-------------------------------------------------------------------------------------------------100
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------+154/------------------------------------------------------------------------------------------------099
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/----------+155
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/----------+155/--------------------------------------------------------------------------------------------------101
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/----------+155/-------------------------------------------------------------------------------------------------100
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/----------+155/------------------------------------------------------------------------------------------------099
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/-----------+156
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/-----------+156/--------------------------------------------------------------------------------------------------101
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/-----------+156/-------------------------------------------------------------------------------------------------100
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/-----------+156/------------------------------------------------------------------------------------------------099
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220/---------------+240
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220/---------------+240/---------------+260
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220/---------------+240/---------------+260/-----------014
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220/---------------+240/-----------014
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220/-----------014
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/-----------014
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/-----------014
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/-----------014
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/-----------014
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/-----------014
----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/-----------014
----------------+020/---------------+040/---------------+060/---------------+080/-----------014
----------------+020/---------------+040/---------------+060/-----------014
----------------+020/---------------+040/-----------014
----------------+020/-----------014
--------------------------------------------------------------------------------------+090
--------------------------------------------------------------------------------------+090/------------------------------------------------------------+155
--------------------------------------------------------------------------------------+090/------------------------------------------------------------+155/-------------------------------------040
--------------------------------------------------------------------------------------+090/-------------------------------------------------------------+156
--------------------------------------------------------------------------------------+090/-------------------------------------------------------------+156/-------------------------------------040
----------------------------------------------------------------------------------------------+-099
----------------------------------------------------------------------------------------------+-099/--------------------------------------------------------------------------------------------------101
----------------------------------------------------------------------------------------------+-099/-------------------------------------------------------------------------------------------------100
----------------------------------------------------------------------------------------------+-099/------------------------------------------------------------------------------------------------099
-----------------------------------------------------------------------------------------------+-100
-----------------------------------------------------------------------------------------------+-100/--------------------------------------------------------------------------------------------------101
-----------------------------------------------------------------------------------------------+-100/-------------------------------------------------------------------------------------------------100
-----------------------------------------------------------------------------------------------+-100/------------------------------------------------------------------------------------------------099
------------------------------------------------------------------------------------------------+-101
------------------------------------------------------------------------------------------------+-101/--------------------------------------------------------------------------------------------------101
------------------------------------------------------------------------------------------------+-101/-------------------------------------------------------------------------------------------------100
------------------------------------------------------------------------------------------------+-101/------------------------------------------------------------------------------------------------099
---------------------------------------------------------------------------------------------------------------------------------------------------------156
---------------------------------------------------------------------------------------------------------------------------------------------------------156/--------------------------------------------------------------------------------------------------101
---------------------------------------------------------------------------------------------------------------------------------------------------------156/-------------------------------------------------------------------------------------------------100
---------------------------------------------------------------------------------------------------------------------------------------------------------156/------------------------------------------------------------------------------------------------099
--------------------------------------------------------------------------------------------------------------------------------------------------------155
--------------------------------------------------------------------------------------------------------------------------------------------------------155/--------------------------------------------------------------------------------------------------101
--------------------------------------------------------------------------------------------------------------------------------------------------------155/-------------------------------------------------------------------------------------------------100
--------------------------------------------------------------------------------------------------------------------------------------------------------155/------------------------------------------------------------------------------------------------099
-------------------------------------------------------------------------------------------------------------------------------------------------------154
-------------------------------------------------------------------------------------------------------------------------------------------------------154/--------------------------------------------------------------------------------------------------101
-------------------------------------------------------------------------------------------------------------------------------------------------------154/-------------------------------------------------------------------------------------------------100
-------------------------------------------------------------------------------------------------------------------------------------------------------154/------------------------------------------------------------------------------------------------099
--------------------------------------------------------------------------------------------------101
-------------------------------------------------------------------------------------------------100
------------------------------------------------------------------------------------------------099
-004
-004/----------------------------------------------------------------------------------------------------------------------------------------------------151
-004/----------------------------------------------------------------------------------------------------------------------------------------------------151/-004'

	EXEC --nosummary -x pax -wdvf star_long_1.pax
		SAME INPUT $data/star-long-1.lst
		OUTPUT -
		SAME ERROR star_long_1.v

	EXEC --nosummary --nostrict -x ustar -wdvf star_long_1.ustar

	EXEC --nosummary --listformat="$testformat" -vf $data/star-long-1.dat
		OUTPUT - $'2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140
2003-09-11+12:25:57 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/--------+153
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/--------+153/--------------------------------------------------------------------------------------------------101
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/--------+153/-------------------------------------------------------------------------------------------------100
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/--------+153/------------------------------------------------------------------------------------------------099
2003-09-11+12:25:57 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------+154
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------+154/--------------------------------------------------------------------------------------------------101
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------+154/-------------------------------------------------------------------------------------------------100
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------+154/------------------------------------------------------------------------------------------------099
2003-09-11+12:25:57 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/----------+155
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/----------+155/--------------------------------------------------------------------------------------------------101
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/----------+155/-------------------------------------------------------------------------------------------------100
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/----------+155/------------------------------------------------------------------------------------------------099
2003-09-11+12:25:57 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/-----------+156
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/-----------+156/--------------------------------------------------------------------------------------------------101
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/-----------+156/-------------------------------------------------------------------------------------------------100
2003-09-11+12:25:57 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/-----------+156/------------------------------------------------------------------------------------------------099
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220/---------------+240
2003-09-11+12:25:56 drwxr-xr-x        0 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220/---------------+240/---------------+260
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220/---------------+240/---------------+260/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220/---------------+240/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/---------------+220/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/---------------+200/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/---------------+180/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/---------------+160/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/---------------+140/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/---------------+120/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/---------------+100/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/---------------+080/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/---------------+060/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/---------------+040/-----------014
2003-09-11+12:25:56 -rw-r--r--        4 ----------------+020/-----------014
2003-09-11+12:25:57 drwxr-xr-x        0 --------------------------------------------------------------------------------------+090
2003-09-11+12:25:57 drwxr-xr-x        0 --------------------------------------------------------------------------------------+090/------------------------------------------------------------+155
2003-09-11+12:25:57 -rw-r--r--        4 --------------------------------------------------------------------------------------+090/------------------------------------------------------------+155/-------------------------------------040
2003-09-11+12:25:57 drwxr-xr-x        0 --------------------------------------------------------------------------------------+090/-------------------------------------------------------------+156
2003-09-11+12:25:57 -rw-r--r--        4 --------------------------------------------------------------------------------------+090/-------------------------------------------------------------+156/-------------------------------------040
2003-09-11+12:25:57 drwxr-xr-x        0 ----------------------------------------------------------------------------------------------+-099
2003-09-11+12:25:57 -rw-r--r--        4 ----------------------------------------------------------------------------------------------+-099/--------------------------------------------------------------------------------------------------101
2003-09-11+12:25:57 -rw-r--r--        4 ----------------------------------------------------------------------------------------------+-099/-------------------------------------------------------------------------------------------------100
2003-09-11+12:25:57 -rw-r--r--        4 ----------------------------------------------------------------------------------------------+-099/------------------------------------------------------------------------------------------------099
2003-09-11+12:25:57 drwxr-xr-x        0 -----------------------------------------------------------------------------------------------+-100
2003-09-11+12:25:57 -rw-r--r--        4 -----------------------------------------------------------------------------------------------+-100/--------------------------------------------------------------------------------------------------101
2003-09-11+12:25:57 -rw-r--r--        4 -----------------------------------------------------------------------------------------------+-100/-------------------------------------------------------------------------------------------------100
2003-09-11+12:25:57 -rw-r--r--        4 -----------------------------------------------------------------------------------------------+-100/------------------------------------------------------------------------------------------------099
2003-09-11+12:25:57 drwxr-xr-x        0 ------------------------------------------------------------------------------------------------+-101
2003-09-11+12:25:57 -rw-r--r--        4 ------------------------------------------------------------------------------------------------+-101/--------------------------------------------------------------------------------------------------101
2003-09-11+12:25:57 -rw-r--r--        4 ------------------------------------------------------------------------------------------------+-101/-------------------------------------------------------------------------------------------------100
2003-09-11+12:25:57 -rw-r--r--        4 ------------------------------------------------------------------------------------------------+-101/------------------------------------------------------------------------------------------------099
2003-09-11+12:25:57 drwxr-xr-x        0 ---------------------------------------------------------------------------------------------------------------------------------------------------------156
2003-09-11+12:25:57 -rw-r--r--        4 ---------------------------------------------------------------------------------------------------------------------------------------------------------156/--------------------------------------------------------------------------------------------------101
2003-09-11+12:25:57 -rw-r--r--        4 ---------------------------------------------------------------------------------------------------------------------------------------------------------156/-------------------------------------------------------------------------------------------------100
2003-09-11+12:25:57 -rw-r--r--        4 ---------------------------------------------------------------------------------------------------------------------------------------------------------156/------------------------------------------------------------------------------------------------099
2003-09-11+12:25:57 drwxr-xr-x        0 --------------------------------------------------------------------------------------------------------------------------------------------------------155
2003-09-11+12:25:57 -rw-r--r--        4 --------------------------------------------------------------------------------------------------------------------------------------------------------155/--------------------------------------------------------------------------------------------------101
2003-09-11+12:25:57 -rw-r--r--        4 --------------------------------------------------------------------------------------------------------------------------------------------------------155/-------------------------------------------------------------------------------------------------100
2003-09-11+12:25:57 -rw-r--r--        4 --------------------------------------------------------------------------------------------------------------------------------------------------------155/------------------------------------------------------------------------------------------------099
2003-09-11+12:25:57 drwxr-xr-x        0 -------------------------------------------------------------------------------------------------------------------------------------------------------154
2003-09-11+12:25:57 -rw-r--r--        4 -------------------------------------------------------------------------------------------------------------------------------------------------------154/--------------------------------------------------------------------------------------------------101
2003-09-11+12:25:57 -rw-r--r--        4 -------------------------------------------------------------------------------------------------------------------------------------------------------154/-------------------------------------------------------------------------------------------------100
2003-09-11+12:25:57 -rw-r--r--        4 -------------------------------------------------------------------------------------------------------------------------------------------------------154/------------------------------------------------------------------------------------------------099
2003-09-11+12:25:56 -rw-r--r--        4 --------------------------------------------------------------------------------------------------101
2003-09-11+12:25:56 -rw-r--r--        4 -------------------------------------------------------------------------------------------------100
2003-09-11+12:25:56 -rw-r--r--        4 ------------------------------------------------------------------------------------------------099
2003-09-11+12:25:57 drwxr-xr-x        0 -004
2003-09-11+12:25:57 drwxr-xr-x        0 -004/----------------------------------------------------------------------------------------------------------------------------------------------------151
2003-09-11+12:25:57 -rw-r--r--        4 -004/----------------------------------------------------------------------------------------------------------------------------------------------------151/-004'
		ERROR -

	EXEC --nosummary --listformat="$testformat" -vf star_long_1.pax

	EXEC --nosummary --listformat="$testformat" -vf star_long_1.ustar

	PROG tw -L -e sort:name -e "name=='-*'" ls -d --format="$testformat" --

TEST 06 'long path test #2 (converted from the star tests for ascii+ebcdic)'

	EXEC --nosummary -f $data/star-long-2.dat
		OUTPUT - $'-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------184 == -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------181 == -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------177 == -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194'

	EXEC --nosummary -rvf $data/star-long-2.dat
		OUTPUT -
		COPY ERROR star_long_2.v
		ERROR - $'-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------184 == -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------181 == -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------177 == -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194'

	EXEC --nosummary -x pax -wdvf star_long_2.pax
		SAME INPUT $data/star-long-2.lst
		OUTPUT -
		SAME ERROR star_long_2.v

	EXEC --nosummary --nostrict -x ustar -wdvf star_long_2.ustar

	EXEC --nosummary --listformat="$testformat" -vf $data/star-long-2.dat
		OUTPUT - $'2003-09-11+12:25:58 -rw-r--r--        3 -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194
2003-09-11+12:25:58 -rw-r--r--        0 ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------184 == -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194
2003-09-11+12:25:58 -rw-r--r--        0 ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------181 == -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194
2003-09-11+12:25:58 -rw-r--r--        0 ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------177 == -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194'
		ERROR -

	EXEC --nosummary --listformat="$testformat" -vf star_long_2.pax

	EXEC --nosummary --listformat="$testformat" -vf star_long_2.ustar

	PROG tw -L -e sort:name -e "name=='-*'" ls -d --format="$testformat" --
		OUTPUT - $'2003-09-11+12:25:58 -rw-r--r--        3 -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------194
2003-09-11+12:25:58 -rw-r--r--        3 ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------184
2003-09-11+12:25:58 -rw-r--r--        3 ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------181
2003-09-11+12:25:58 -rw-r--r--        3 ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------177'

TEST 07 'stress and malformed archives (from the star tests)'

	EXEC --nosummary --listformat="$testformat" -f $data/star-gnu-fail-1.dat
		OUTPUT - $'2001-05-25+10:41:06 -rw-r--r--      518 vedpowered.gif
1997-04-28+20:19:16 -rw-r--r--     6825 cd.gif
1999-06-22+08:17:38 -rw-r--r--    33354 DSCN0049c.JPG
2001-06-05+14:16:04 -rw-r--r--    86159 Window1.jpg
2001-05-25+09:05:41 -rw-r--r--     1310 vipower.gif
1998-09-15+09:08:15 -rw-rw-rw-   148753 billyboy.jpg'

	EXEC --nosummary --listformat="$testformat" -f $data/star-gnu-fail-2.dat
		OUTPUT - $'2001-09-21+10:08:36 -rwxr-xr-x      214 .clean
1998-05-07+08:39:00 lrwxrwxrwx        0 RULES -> makefiles/RULES
2001-12-09+19:00:58 drwxr-sr-x        0 build
2001-12-09+19:00:20 -rw-r--r--   312019 build/smake-1.2.tar.gz
2001-11-09+13:20:33 drwxr-sr-x        0 build/psmake
2000-01-09+11:36:34 -rwxr-xr-x      259 build/psmake/MAKE
2001-02-25+17:45:53 -rwxr-xr-x     4820 build/psmake/MAKE.sh
2001-02-25+18:50:06 -rw-r--r--      647 build/psmake/Makefile
2001-08-29+06:53:53 lrwxrwxrwx        0 build/psmake/archconf.c -> ../archconf.c
2001-08-29+06:54:00 lrwxrwxrwx        0 build/psmake/astoi.c -> ../../lib/astoi.c'

	EXEC -v
		SAME INPUT $data/star-all-fail-1.dat
		OUTPUT -
		ERROR - $'pax: /dev/stdin: unknown input format'
		EXIT 1

TEST 08 'all in one test (ustar-all-quicktest.tar from the star tests)'

	EXEC --nosummary --listformat="$testformat" -f $data/star-test.dat
		OUTPUT - $'1994-06-15+16:31:04 -rw-r--r-T     1024 0-type-old-file
1994-06-15+16:31:16 -rw-r--r-T     1024 0-type-regular-file
1994-06-15+16:31:16 -rw-r--r-T        0 1-type-hardlink == 0-type-regular-file
2002-06-15+08:13:12 lrwxrwxrwx        0 2-type-symlink -> file
1994-06-15+16:32:18 crw-r--r--        0 3-type-cdev
1994-06-15+16:32:28 brw-r--r--        0 4-type-bdev
1994-06-15+16:32:32 drwxr-sr-x        0 5-type-dir
1994-06-15+16:32:50 prw-r--r--        0 6-type-fifo
2002-06-15+08:31:17 -rw-r--r--    10240 7-type-contfile
2002-06-18+19:40:48 -rw-r--r--        0 0-jrg-signed
2001-12-18+16:05:37 -rwxrwxrwx        0 12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/1234567890
2001-12-18+16:05:37 -rwxrwxrwx        0 9-9-tar-longlink == 12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/1234567890
2002-06-18+19:50:15 -rw-r--r--        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/9876543210
2002-06-18+19:58:13 -rw-r--r--        0 12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/123456789.
2002-06-18+19:58:13 -rw-r--r--        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/9876543210 == 12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/123456789.
2002-06-18+20:03:54 -rw-r--r--        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321.
2002-06-18+20:18:50 crw-r--r--        0 3-type-cdev-s
2002-06-18+20:18:03 brw-r--r--        0 4-type-bdev-s
2002-06-18+20:17:09 drwxr-xr-x        0 5-type-dir-s
2002-06-18+20:17:26 prw-r--r--        0 6-type-fifo-s
2002-06-19+12:18:52 -rw-r--r--        0 999'

	EXEC --nosummary --listformat="$testformat"
		SAME INPUT $data/star-test.dat

	EXEC --nosummary -rvf $data/star-test.dat
		INPUT -
		OUTPUT -
		ERROR - $'0-type-old-file
0-type-regular-file
1-type-hardlink == 0-type-regular-file
2-type-symlink -> file
pax: 3-type-cdev: cannot create character special file
pax: 4-type-bdev: cannot create block special file
5-type-dir
7-type-contfile
0-jrg-signed
12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/1234567890
9-9-tar-longlink == 12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/1234567890
987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/9876543210
12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/123456789.
187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/9876543210 == 12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/123456789.
287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321.
pax: 3-type-cdev-s: cannot create character special file
pax: 4-type-bdev-s: cannot create block special file
5-type-dir-s
999'
		EXIT 1

	PROG tw -L -e sort:name -e "name=='[a-z0-9]*'" ls -d --testdate=2003-08-11+12:34:56 --format="$testformat"
		OUTPUT - $'2002-06-18+19:40:48 -rw-r--r--        0 0-jrg-signed
1994-06-15+16:31:04 -rw-r--r-T     1024 0-type-old-file
1994-06-15+16:31:16 -rw-r--r-T     1024 0-type-regular-file
1994-06-15+16:31:16 -rw-r--r-T     1024 1-type-hardlink
2003-08-11+12:34:56 drwxrwxrwx        0 12345678901234
2003-08-11+12:34:56 drwxrwxrwx        0 12345678901234/12345678901234
2003-08-11+12:34:56 drwxrwxrwx        0 12345678901234/12345678901234/12345678901234
2003-08-11+12:34:56 drwxrwxrwx        0 12345678901234/12345678901234/12345678901234/12345678901234
2003-08-11+12:34:56 drwxrwxrwx        0 12345678901234/12345678901234/12345678901234/12345678901234/12345678901234
2003-08-11+12:34:56 drwxrwxrwx        0 12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/12345678901234
2002-06-18+19:58:13 -rw-r--r--        0 12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/123456789.
2001-12-18+16:05:37 -rwxrwxrwx        0 12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/12345678901234/1234567890
2003-08-11+12:34:56 drwxrwxrwx        0 187654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2002-06-18+19:58:13 -rw-r--r--        0 187654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/9876543210
2003-08-11+12:34:56 lrwxrwxrwx        0 2-type-symlink -> file
2003-08-11+12:34:56 drwxrwxrwx        0 287654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2002-06-18+20:03:54 -rw-r--r--        0 287654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321.
1994-06-15+16:32:32 drwxr-xr-x        0 5-type-dir
2002-06-18+20:17:09 drwxr-xr-x        0 5-type-dir-s
1994-06-15+16:32:50 prw-r--r--        0 6-type-fifo
2002-06-18+20:17:26 prw-r--r--        0 6-type-fifo-s
2002-06-15+08:31:17 -rw-r--r--    10240 7-type-contfile
2001-12-18+16:05:37 -rwxrwxrwx        0 9-9-tar-longlink
2003-08-11+12:34:56 drwxrwxrwx        0 987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2003-08-11+12:34:56 drwxrwxrwx        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321
2002-06-18+19:50:15 -rw-r--r--        0 987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/98765/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/987654321/9876543210
2002-06-19+12:18:52 -rw-r--r--        0 999'
		ERROR -
		EXIT 0

TEST 09 'readonly directories and file'

	EXEC --nosummary -rvf $data/ro.dat
		ERROR - $'a
a/b
a/b/c
a/b/c/d
a/b/c/d/e
a/b/c/d/e/f'

	EXEC --nosummary --listformat="$testformat" -vf $data/ro.dat
		OUTPUT - $'1979-08-11+18:10:23 dr-xr-xr-x        0 a
2003-06-30+00:00:00 dr-xr-xr-x        0 a/b
2001-07-30+00:00:00 dr-xr-xr-x        0 a/b/c
1999-08-30+00:00:00 dr-xr-xr-x        0 a/b/c/d
1997-09-29+00:00:00 dr-xr-xr-x        0 a/b/c/d/e
1995-10-31+00:00:00 -r--r--r--        4 a/b/c/d/e/f'
		ERROR -

	PROG tw -L -d a -e sort:name ls -d --format="$testformat"

TEST 10 'tar format details'

	EXEC --nosummary -rf $data/aha.dat

	EXEC --nosummary -x pax --uid:=01234567 --gid:=01234567 -wf t.pax aha

	EXEC --nosummary --listformat='%(uid)d %(gid)d' --file=t.pax
		OUTPUT - $'1234567 1234567'

	EXEC --nosummary -x pax --uid:=0123456 --gid:=0123456 -wf t.pax aha
		OUTPUT -

	EXEC --nosummary --listformat='%(uid)d %(gid)d' --file=t.pax
		OUTPUT - $'123456 123456'

	EXEC --nosummary -x pax --uid:=012345 --gid:=012345 -wf t.pax aha
		OUTPUT -

	EXEC --nosummary --listformat='%(uid)d %(gid)d' --file=t.pax
		OUTPUT - $'12345 12345'

	EXEC --nosummary -x pax --uid:=01234 --gid:=01234 -wf t.pax aha
		OUTPUT -

	EXEC --nosummary --listformat='%(uid)d %(gid)d' --file=t.pax
		OUTPUT - $'1234 1234'

TEST 11 'pax delta format'

	EXEC --listformat="$testformat" -vf $data/base.pax
		OUTPUT - $'2003-09-29+17:17:50 -rw-r--r--        7 delete.dat
2003-09-28+00:00:00 -rw-r--r--        8 update.dat
2003-09-29+17:17:50 -rw-r--r--        7 verify.dat'
		ERROR - "$data/base.pax in gzip pax format
3 files, 10 blocks"

	EXEC --listformat="$testformat" -vf $data/delta.pax -z $data/base.pax
		OUTPUT - $'2003-09-29+17:17:50 -rw-r--r--        7 create.dat
2003-09-29+17:17:50 -rw-r--r--       18 update.dat
2003-09-29+17:17:50 -rw-r--r--        0 delete.dat'
	ERROR - "$data/delta.pax base $data/base.pax in gzip pax format
$data/delta.pax in gzip delta pax format
3 files, 17 blocks"

	EXEC --nosummary --listformat="$testformat" -vf $data/delta.pax
		ERROR - "pax: warning: $data/delta.pax: base archive must be specified"

	EXEC --nosummary --listformat="$testformat" -vf $data/delta-2.pax -z $data/base.pax
		ERROR - "pax: warning: $data/delta-2.pax: $data/base.pax: base archive checksum mismatch -- expected 7f8b455f, got 43f07b5f"

	EXEC --nosummary --listformat="$testformat" -vf $data/delta-3.pax -z $data/base.pax
		ERROR - "pax: $data/delta-3.pax: update.dat: corrupt archive: delta index out of sync by 1 file
pax: $data/delta-3.pax: delete.dat: corrupt archive: 3 missing files"
		EXIT 1

	EXEC --nosummary --listformat="$testformat" -vf $data/delta-4.pax -z $data/base.pax
		ERROR - "pax: $data/delta-4.pax: update.dat: corrupt archive: 1 missing file
pax: $data/delta-4.pax: delete.dat: corrupt archive: 1 missing file
pax: $data/delta-4.pax: corrupt archive: 2 missing files"

	EXEC --nosummary --listformat="$testformat" -vf $data/delta-5.pax -z $data/base.pax
		ERROR - "pax: $data/delta-5.pax: corrupt archive: 1 extra file"

	EXEC --nosummary --listformat="$testformat" -vf $data/delta-6.pax -z $data/base.pax
		ERROR - "pax: $data/delta-6.pax: corrupt archive: 1 missing file"

	EXEC --nosummary --listformat="$testformat" -vf $data/delta-7.pax -z $data/base.pax
		ERROR - "pax: $data/delta-7.pax: corrupt archive: 5 missing files"

	EXEC --nosummary --listformat="$testformat" -vf $data/delta.pax -z $data/base-1.pax
		ERROR - "pax: warning: $data/delta.pax: $data/base-1.pax: base archive checksum mismatch -- expected 43f07b5f, got 99ed64bf
pax: $data/delta.pax: delete.dat: corrupt archive: checksum mismatch -- expected ef86c976, got 359bd696"

	EXEC --nosummary --listformat="$testformat" -vf $data/delta.pax -z $data/base-2.pax
		OUTPUT -
		ERROR - "pax: $data/delta.pax: $data/base-2.pax: base archive size mismatch -- expected 5120, got 4096"

	EXEC --nosummary --listformat="$testformat" -vf $data/delta-1.pax -z $data/base.pax
		ERROR - "pax: $data/delta-1.pax: zelta: delta method not supported"

TEST 12 'extraction basics'

	EXEC --nosummary -rf $data/extract.pax
	PROG md5sum *.dat
		MOVE OUTPUT sum
	PROG diff sum md5

TEST 13 '--install and --checksum'

	DO DATA t.c1 t.i t.r t.s t.x

	EXEC --nosummary --install=INSTALL -wf t.pax t.r t.s t.x
	EXEC --nosummary -rf t.pax INSTALL
	PROG diff INSTALL t.i

	EXEC --nosummary --checksum=md5:CHECKSUM -wf t.pax t.r t.s t.x
	EXEC --nosummary -rf t.pax CHECKSUM
	PROG diff CHECKSUM t.c1

TEST 14 '--filter and --action'

	DO DATA t.c2 t.c3 t.c4 t.n t.r t.s

	EXEC --nosummary --checksum=md5:CHECKSUM --filter='sed "s/^ ... $/---/"' -wf t.pax t.n t.r t.s
	EXEC --nosummary -rf t.pax CHECKSUM
	PROG diff CHECKSUM t.c2

	EXEC --nosummary --checksum=md5:CHECKSUM --action='/*.r/sed "s/^ ... $/AAA/"' --action='/*.s/sed "s/^ ... $/ZZZ/"' -wf t.pax t.n t.r t.s
	EXEC --nosummary -rf t.pax CHECKSUM
	PROG diff CHECKSUM t.c3

	EXEC --nosummary --checksum=md5:CHECKSUM --filter=- -wf t.pax
		INPUT - $';;;t.n;fn.dat
;;sed "s/^ ... $/---/" < t.r;t.r;fr.dat
;;;t.s'
	EXEC --nosummary -rf t.pax CHECKSUM
	PROG diff CHECKSUM t.c4

TEST 15 'append among friends'

	DO DATA b1 b2 a1

	for b in $formats
	do
		for a in $formats
		do

	EXEC --nosummary -wvf x -x $b b1
		OUTPUT -
		ERROR - $'b1'

	EXEC --nosummary -awvf x -x $a a1
		ERROR - $'a1'

	EXEC --nosummary --listformat="$dateformat" -vf x
		OUTPUT - $'2000-01-02/03:04:05 b1\n2005-06-07/08:09:10 a1'
		ERROR -

	EXEC --nosummary -wvf x -x $b b1 b2
		OUTPUT -
		ERROR - $'b1\nb2'

	EXEC --nosummary -awvf x -x $a a1
		ERROR - $'a1'

	EXEC --nosummary --listformat="$dateformat" -vf x
		OUTPUT - $'2000-01-02/03:04:05 b1\n2005-04-03/01:01:00 b2\n2005-06-07/08:09:10 a1'
		ERROR -

		done
	done

TEST 16 'skip over >2Gb member'

	EXEC --nosummary --listformat="$testformat" -vf $data/bigskip.pax
		OUTPUT - $'2004-08-06+11:08:56 -rw-r--r-- 2814840497 begin
2004-08-06+11:10:07 -rw-r--r--        4 end
2004-08-06+11:10:04 -rw-r--r--        7 middle'
