/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkditembase.h"
#include "../kkaddressbook/kkacontactdata.h"

#include <kiconloader.h>
#include <kdebug.h>

using namespace KKDesigner;

/**
 * Constructor for KKDCmdInsert
 * @param x
 * @param y
 * @param width
 * @param height
 * @param parent
 */
KKDItemBase::KKDItemBase( int x, int y, int width, int height, QObject* parent )
	: QObject( parent )
	, m_location( QPoint( x, y ) )
	, m_size( QSize( width, height ) )
	, m_locked( false )
	, m_selected( true )
{
}

/**
 * Constructor for xml file.
 * @param e
 * @param parent
 */
KKDItemBase::KKDItemBase( QDomElement e, QObject* parent )
	: QObject( parent )
	, m_location( QPoint( e.hasAttribute( "x" ) ? e.attribute( "x" ).toInt() : 0
						, e.hasAttribute( "y" ) ? e.attribute( "y" ).toInt() : 0 ) )
	, m_size( QSize( e.hasAttribute( "width" ) ? e.attribute( "width" ).toInt() : 10
				   , e.hasAttribute( "height" ) ? e.attribute( "height" ).toInt() : 10 ) )
	, m_locked( e.hasAttribute( "locked" ) )
	, m_selected( e.hasAttribute( "selected" ) )
{
}

/**
 * Copy constructor
 * @param item
 * @param parent
 */
KKDItemBase::KKDItemBase( const KKDItemBase* item, QObject* parent )
	: QObject( parent )
	, m_location( item->m_location )
	, m_size( item->m_size )
	, m_locked( item->m_locked )
	, m_selected( item->m_selected )
{
}

/**
 * Destructor
 */
KKDItemBase::~KKDItemBase()
{
}

// BEGIN Properties
void KKDItemBase::setLocation( int x, int y )
{
	if( m_locked ) return;
	if( m_location.x() == x && m_location.y() == y ) return;
	QRect r = rect();
	m_location.setX( x );
	m_location.setY( y );
	emit repaint( r | rect() );
	emit locationChanged();
}

void KKDItemBase::setSize( int width, int height )
{
	if( m_locked ) return;
	if( m_size.width() == width && m_size.height() == height ) return;
	QRect r = rect();
	m_size.setWidth( width );
	m_size.setHeight( height );
	emit repaint( r | rect() );
	emit sizeChanged();
}

void KKDItemBase::setLocked( bool l )
{
	if( m_locked == l ) return;
	m_locked = l;
	emit repaint( rect() );
	emit lockedChanged();
}

void KKDItemBase::setSelected( bool s )
{
	if( m_selected == s ) return;
	m_selected = s;
	emit repaint( rect() );
	emit selectedChanged();
}
// END Properties

/**
 * Create dom element for save.
 * @param doc QDomDocument
 * @param t tag name
 * @returns QDomElement
 */
QDomElement KKDItemBase::toElement( QDomDocument& doc, const QString& t )
{
	QDomElement elem = doc.createElement( t );
	elem.setAttribute( "x", m_location.x() );
	elem.setAttribute( "y", m_location.y() );
	elem.setAttribute( "width", size().width() );
	elem.setAttribute( "height", size().height() );
	if( m_locked ) elem.setAttribute( "locked", 1 );
	if( m_selected ) elem.setAttribute( "selected", 1 );
	return elem;
}

void KKDItemBase::drawItem( QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d )
{
	QRect r( m_location, m_size );
	drawItemBefore( r, p, m, d );
	drawItemAfter( r, p, m, d );
}

void KKDItemBase::drawItemBefore( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d )
{
}

void KKDItemBase::drawItemAfter( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d )
{
	switch( m )
	{
		case DesignMode:
			p.setPen( gray );
			if( selected() )
			{
				p.setPen( locked() ? red : QColor( 68, 102, 255 ) );
			}
			p.drawLine( r.topLeft(), r.topRight() );
			p.drawLine( r.topRight(), r.bottomRight() );
			p.drawLine( r.bottomRight(), r.bottomLeft() );
			p.drawLine( r.bottomLeft(), r.topLeft() );

			if( selected() && locked() )
			{
				QPixmap pxmLocked = SmallIcon( "encrypted" );
				QRect rLocked( r.topRight() - QPoint( pxmLocked.width(), 0 ), pxmLocked.size() );
				p.drawPixmap( rLocked, pxmLocked );
			}
			break;
		case PreviewMode:
		case AddressMode:
			if( type() == Paper )
			{
				p.setPen( gray );
				p.drawLine( r.topLeft(), r.topRight() );
				p.drawLine( r.topRight(), r.bottomRight() );
				p.drawLine( r.bottomRight(), r.bottomLeft() );
				p.drawLine( r.bottomLeft(), r.topLeft() );
			}
			break;
		default:
			break;
	}

}
