/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkaofficeaddress.h"

#include <qdom.h>

using namespace KKAddressBook;

KKAOfficeAddress::KKAOfficeAddress( QObject* parent )
 : KKAAddressData( parent, Office )
 , m_corporation( QString::null )
 , m_section( QString::null )
 , m_post( QString::null )
{
}

KKAOfficeAddress::KKAOfficeAddress( QObject* parent
								  , const QString& co
								  , const QString& se
								  , const QString& po
								  , const QString& c
								  , const QString& z
								  , const QString& a
								  )
 : KKAAddressData( parent
 				 , Office
 				 , c
 				 , z
 				 , a
 				 , None
 				 )
 , m_corporation( co )
 , m_section( se )
 , m_post( po )
{
}

KKAOfficeAddress::KKAOfficeAddress( QObject* parent, QDomElement& e )
 : KKAAddressData( parent, e )
 , m_corporation( e.attribute( "corporation" ) )
 , m_section( e.attribute( "section" ) )
 , m_post( e.attribute( "post" ) )
{
}

KKAOfficeAddress::~KKAOfficeAddress()
{
}

QDomElement KKAOfficeAddress::toElement( QDomDocument& doc )
{
	QDomElement elem = KKAAddressData::toElement( doc );
	elem.setAttribute( "corporation", m_corporation );
	elem.setAttribute( "section", m_section );
	elem.setAttribute( "post", m_post );
	return elem;
}

void KKAOfficeAddress::setCorporation( const QString& c )
{
	if( m_corporation == c ) return;
	m_corporation = c;
	emit updated();
}

void KKAOfficeAddress::setSection( const QString& s )
{
	if( m_section == s ) return;
	m_section = s;
	emit updated();
}

void KKAOfficeAddress::setPost( const QString& p )
{
	if( m_post == p ) return;
	m_post = p;
	emit updated();
}
