/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKAADDRESSDATA_H_
#define _KKAADDRESSDATA_H_

#include <qobject.h>

class QDomDocument;
class QDomNode;
class QDomElement;

namespace KKAddressBook
{
	/**
	 * @english
	 * @short Address Data
	 * This class includes county, zipcode and so on.
	 * @author SUZUKI Tasuku
	 * @endenglish
	 *
	 * @japanese
	 * @short 住所データ
	 * 国名や郵便番号などを含みます
	 * @author 鈴木 佑
	 * @endjapanese
	 */
	class KKAAddressData : public QObject
	{
		Q_OBJECT

		/**
		 * @property locationType
		 * @japanese
		 * @brief 住所種別
		 * @endjapanese
		 * @see LocationType
		 */
		Q_PROPERTY( LocationType locationType READ locationType WRITE setLocationType )

		/**
		 * @property preference
		 * @japanese
		 * @brief 優先かどうか
		 * @endjapanese
		 */
		Q_PROPERTY( bool preference READ preference WRITE setPreference )

		/**
		 * @property country
		 * @japanese
		 * @brief 国名
		 * @endjapanese
		 */
		Q_PROPERTY( QString country READ country WRITE setCountry )

		/**
		 * @property zipcode
		 * @japanese
		 * @brief 郵便番号
		 * @endjapanese
		 * @see zipcodeDomain
		 */
		Q_PROPERTY( QString zipcode READ zipcode WRITE setZipcode )

		/**
		 * @property address
		 * @japanese
		 * @brief 住所
		 * @endjapanese
		 */
		Q_PROPERTY( QString address READ address WRITE setAddress )

		Q_ENUMS( LocationType )

	public:
		/**
		 * @japanese
		 * @brief 住所種別
		 * @endjapanese
		 * @see locationType
		 */
		enum LocationType
		{
			/**
			 * @japanese
			 * 自宅
			 * @endjapanese
			 */
			Home,
			/**
			 * @japanese
			 * 勤務先
			 * @endjapanese
			 */
			Office,
		};

		enum PrintStatus
		{
			None,
			Print,
			Printed,
		};
		KKAAddressData( QObject* parent, LocationType l );
		KKAAddressData( QObject* parent
					  , LocationType l
					  , const QString& c
					  , const QString& z
					  , const QString& a
					  , PrintStatus p
					  );
		KKAAddressData( QObject* parent, QDomElement& e );

		virtual ~KKAAddressData();

		static const QString tagName(){ return "addressdata"; }
		virtual QDomElement toElement( QDomDocument& doc );

		//BEGIN Properties
		LocationType locationType() const { return m_locationType; }
		bool preference() const { return m_preference; }

		const QString& country() const { return m_country; }
		const QString& zipcode() const { return m_zipcode; }
		const QString& address() const { return m_address; }

		PrintStatus printStatus() const{ return m_printStatus; }
		//END   Properties

	public slots:
		//BEGIN Properties
		void setLocationType( LocationType l );
		void setPreference( bool p );

		void setCountry( const QString& c );
		void setZipcode( const QString& z );
		void setAddress( const QString& a );

		void setPrintStatus( KKAAddressData::PrintStatus p );
		//END   Properties

	signals:
		void updated();
		void printStatusChanged( KKAAddressData::PrintStatus );

	private:
		LocationType m_locationType;
		bool m_preference;

		QString m_country;
		QString m_zipcode;
		QString m_address;

		PrintStatus m_printStatus;
	};
}

#endif /* _KKAADDRESSDATA_H_ */
