


#include "configParameters.h"
#include "defines.h"

#include <ksimpleconfig.h>


/*!
    It loads config file too
*/
configParameters::configParameters() {

    load();

}



void configParameters::save() {
    KSimpleConfig cfg ( defaults::KRecordMyDesktop_ConfigFile );
    cfg.setGroup ( "Recordmydesktop_Parameters" );
    cfg.writeEntry ( "videoQuality", params.videoQuality );
    cfg.writeEntry ( "audioQuality", params.audioQuality );
    cfg.writeEntry ( "audioEnabled", params.audioEnabled );
    cfg.writeEntry ( "workingDir", params.workingDir );
    cfg.writeEntry ( "framesPerSecond", params.fps );
    cfg.writeEntry ( "encodeOnTheFly", params.encodeOnTheFly );
    cfg.writeEntry ( "rmdPath", params.rmdPath );
    cfg.writeEntry ( "otherParams", params.otherParams );
    cfg.sync();
}


void configParameters::load() {
    KSimpleConfig cfg ( defaults::KRecordMyDesktop_ConfigFile );
    cfg.setGroup ( "Recordmydesktop_Parameters" );
    params.videoQuality = cfg.readNumEntry ( "videoQuality", 100 );
    params.audioQuality = cfg.readNumEntry ( "audioQuality", 10 );
    params.audioEnabled = cfg.readBoolEntry ( "audioEnabled", true );
    params.workingDir = cfg.readEntry ( "workingDir", "/tmp/" );
    params.fps = cfg.readNumEntry ( "framesPerSecond", 25 );
    params.encodeOnTheFly = cfg.readBoolEntry ( "encodeOnTheFly", false );
    params.rmdPath = cfg.readEntry ( "rmdPath", "recordmydesktop" );
    params.otherParams = cfg.readEntry ( "otherParams", "" );
}

void configParameters::copy ( const configParameters& c ) {
    params.videoQuality = c.params.videoQuality;
    params.audioQuality = c.params.audioQuality;
    params.audioEnabled = c.params.audioEnabled;
    params.workingDir = c.params.workingDir;
    params.fps = c.params.fps;
    params.encodeOnTheFly = c.params.encodeOnTheFly;
    params.rmdPath = c.params.rmdPath;
    params.otherParams = c.params.otherParams;
}

