

#ifndef _config_dialog_h_
#define _config_dialog_h_


#include "configDialogBase.h"
#include "configParameters.h"

#include "defines.h"

#include <qslider.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <krestrictedline.h>
#include <knuminput.h>
#include <ksimpleconfig.h>
#include <kfiledialog.h>


/*!
    Configuration dialog class
*/
/// Configuration dialog class
class configDialog : public configDialogBase {

    Q_OBJECT

    private:
    configParameters* p_cfg;
    
    bool initialized;
    
    /// set values specified in config to user interface
    void setUIValues ( void ) {
        DBG ( "Setting preferences dialog values" );
        slider_vq->setValue ( p_cfg->params.videoQuality );
        slider_aq->setValue ( p_cfg->params.audioQuality );
        checkBox_audioEnabled->setChecked ( p_cfg->params.audioEnabled );
        kRestrictedLine_tempPath->setText ( p_cfg->params.workingDir );
        kIntNumInput_fps->setValue ( p_cfg->params.fps );
        checkBox_encodeOnTheFly->setChecked ( p_cfg->params.encodeOnTheFly );
        kRestrictedLine_rmdPath->setText ( p_cfg->params.rmdPath );
        kRestrictedLine_otherParams->setText ( p_cfg->params.otherParams );
        
    }

    /// get values specified in user interface to config class
    void getUIValues ( void ) {
        DBG ( "Getting preferences dialog values" );
        p_cfg->params.videoQuality = slider_vq->value();
        p_cfg->params.audioQuality = slider_aq->value();
        p_cfg->params.audioEnabled = checkBox_audioEnabled->isOn();
        p_cfg->params.workingDir = kRestrictedLine_tempPath->text();
        p_cfg->params.fps = kIntNumInput_fps->value();
        p_cfg->params.encodeOnTheFly = checkBox_encodeOnTheFly->isOn();
        p_cfg->params.rmdPath = kRestrictedLine_rmdPath->text();
        p_cfg->params.otherParams = kRestrictedLine_otherParams->text();
    }


    public:

    /// constructor
    /*!
        Constructor parses configuration values and sets all widgets to configured values
    */
    configDialog ( QWidget* parent, configParameters* p_p ) : configDialogBase ( parent, "Configure dialog" ), initialized ( false ) {
        DBG("");
        p_cfg = p_p;
        setUIValues();
        initialized = true;
    }

    /// destructor
    /*!
        Destructor stores changes into configuration structure back
    */
    ~configDialog() {
        DBG("");
    }


    void slotSaveSettings() {
        DBG ( "Saving settings" );
        p_cfg->save();
        getUIValues();
    }

    /// get temp dir file dialog
    void slotSelectTempDir() {
        DBG ( "select temp dir" );
        // open file dialog and select directory
        QString tmp = KFileDialog::getExistingDirectory();
        // nothing selected / cancel
        if ( tmp.isNull() ) return;
        // set value in gui ( signal then calls slotAnyValueChanged() and value will be saved
        kRestrictedLine_tempPath->setText ( tmp );
        DBG ( "tmp path=" << tmp );
    }
    
    /// get recordmydesktop file dialog
    void slotSelectRmdPath() {
        DBG ( "Get rmd path" );
        // open file dialog and select file
        QString tmp = KFileDialog::getOpenFileName ( "~" );
        // nothing selected / cancel
        if ( tmp.isNull() ) return;
        // set value in gui ( signal then calls slotAnyValueChanged() and value will be saved
        kRestrictedLine_rmdPath->setText ( tmp );
        DBG ( "rmd path=" << tmp );
    }
    
    
    /// this slot is called everytime any value changes
    void slotAnyValueChanged() {
        DBG ( "Any value changed" );
        if ( initialized ) getUIValues();
        
        // enable/disable audio quality slider
        if ( checkBox_audioEnabled->isOn() ) {
            slider_aq->setEnabled ( true );
            textLabel_aq->setEnabled ( true );
        }
        else {
            slider_aq->setEnabled ( false );
            textLabel_aq->setEnabled ( false );
        }
    }


};


#endif

