/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SETTINGS_STREAM_WIDGET_SAVING_H
#define SETTINGS_STREAM_WIDGET_SAVING_H

#include "ui_settings_stream_widget_saving.h"

/** \brief Widget for the "saving" options in the stream configuration
*          (for use with a KConfigDialog).
*
* It uses the UI that is generated with Qt-Designer.
*
* \sa settings_stream */
class settings_stream_widget_saving : public QWidget, private Ui::settings_stream_widget_saving
{
  Q_OBJECT

  public:
    /** The constructor. */
    settings_stream_widget_saving(QWidget *parent=0);
    /** The destructor. */
    virtual ~settings_stream_widget_saving();

  private slots:
    /** If duplicate files will be overwritten "always", than we
    *   disable the checkbox <tt>kcfg_truncateDuplicatesInIncomplete</tt> because
    *   there won't exist any duplicate. If they are overwritten
    *   "if larger" or "never", than there could exist duplicates,
    *   so we enable the checkbox <tt>kcfg_truncateDuplicatesInIncomplete</tt>.
    *
    *   This behavior can't be realized in Qt-Designer, so it
    *   is coded here.
    *
    *   The constructor connects this slot to the signal
    *   <tt>currentIndexChanged(int)</tt> from the ComboBox
    *   <tt>kcfg_splittedFilesOverwrite</tt>.
    *
    *   @param entry_number The number of the entry that has been chosen
    *   in the ComboBox <tt>kcfg_splittedFilesOverwrite</tt>. */
    void handleCheckboxTruncate(const int entry_number);
};

#endif
