#!/bin/sh
# Extracts the messages which have to be translated, puts them in a .pot file
# and merges this .pot file with the existing translations.
# based on code from
# http://techbase.kde.org/Development/Tutorials/Localization/i18n_Build_Systems
SCRIPTDIR=`pwd`


BASEDIR="${SCRIPTDIR}/../src/"          # root of translatable sources
TIPOFTHEDAYDIR="${SCRIPTDIR}/../data/"  # directory with the tips of the day
PROJECT="kradioripper"                  # project name
BUGADDR="http://sourceforge.net/projects/kradioripper/"      # MSGID-Bugs
WDIR="${SCRIPTDIR}/../po"               # working dir
 
 
export PATH=/usr/bin:$PATH
 
 
echo "Preparing rc files"
cd ${BASEDIR}
# we use simple sorting to make sure the lines do not jump around too much from system to system
find . -name '*.rc' -o -name '*.ui' -o -name '*.kcfg' | sort > ${WDIR}/rcfiles.list
export PATH=/usr/bin:$PATH # We want to use the KDE 4 version of extractrc!
xargs --arg-file=${WDIR}/rcfiles.list extractrc > ${WDIR}/rc.cpp
cd ${WDIR}
echo "Done preparing rc files"
 
 
echo "Preparing tips of the day"
cd ${TIPOFTHEDAYDIR}
preparetips > ${WDIR}/tipsoftheday.cpp
cd ${WDIR}
echo "Done preparing tips of the day"
 
 
echo "Extracting messages"
cd ${BASEDIR}
# see above on sorting
find . -name '*.cpp' -o -name '*.h' -o -name '*.c' | sort > ${WDIR}/infiles.list
echo "./rc.cpp" >> ${WDIR}/infiles.list
echo "./tipsoftheday.cpp" >> ${WDIR}/infiles.list
cd ${WDIR}
xgettext --from-code=UTF-8 -C -kde -ci18n -ki18n:1 -ki18nc:1c,2 -ki18np:1,2 -ki18ncp:1c,2,3 -ktr2i18n:1 \
        -kI18N_NOOP:1 -kI18N_NOOP2:1c,2 -kaliasLocale -kki18n:1 -kki18nc:1c,2 -kki18np:1,2 -kki18ncp:1c,2,3 \
   --msgid-bugs-address="${BUGADDR}" \
     --files-from=infiles.list -D ${BASEDIR} -D ${WDIR} -o ${PROJECT}.pot || { echo "error while calling xgettext. aborting."; exit 1; }
echo "Done extracting messages"
 
 
echo "Merging translations"
catalogs=`find . -name '*.po'`
for cat in $catalogs; do
  echo $cat
  msgmerge -o $cat.new $cat ${PROJECT}.pot
  mv $cat.new $cat
done
echo "Done merging translations"
 
 
echo "Cleaning up"
cd ${WDIR}
rm rcfiles.list
rm infiles.list
rm rc.cpp
rm tipsoftheday.cpp
echo "Done cleaning up" 
