/***************************************************************************
                          fixtext.cpp  -  description
                             -------------------
    begin                : Wed Jul 12 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qsignalmapper.h>
#include <klocale.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <stdio.h>
#include "fixtext.h"

#include "globals.h"
#include "logbook.h"

/** Defined Macros:

		<TX>						Switch to Transmit
		<RX>						Switch to Receive
		<MYNAME>  			Sends the Operators Name
		<MYCALL>				Sends the Operators Callsign
		<MYQTH>					Sends the Operators Location
		<BAND>					Sends the current operating frequency
		<CALL>					Sends the current distant callsign
		<NAME>					Sends the current distant name
		<QTH>						Sends the current distant QTH
		<RSTR>					Sends the rapport you got
		<RSTS>					Sends the rapport you gave
		<CALLCHECHON>   Enables the Call check
		<CALLCHECKOFF>  Disables the Call check

*/

fixText::fixText(QWidget *parent, const char *name ) : QWidget(parent,name)
{
	int i;
	QSignalMapper* map = new QSignalMapper (this);
	QHBoxLayout* box = new QHBoxLayout (this);
	box->addSpacing (2);
	box->setSpacing (2);
	for (i=0;i<12;++i) {
		if (i==4) box->addSpacing (4);
		if (i==8) box->addSpacing (4);
		button[i] = new QPushButton (this);
		button[i]->setMinimumWidth (1);
		map->setMapping (button[i], i);
		QObject::connect (button[i], SIGNAL (clicked()), map, SLOT (map()));
		box->addWidget (button[i]);
	}	
	QObject::connect (map, SIGNAL (mapped (int)), this, SLOT (slotButtonPressed (int)));
	box->addSpacing (2);
	
  setLabels();
}

fixText::~fixText()
{
}

void fixText::slotButtonPressed (int i)
{
	QString str = config.fixtext.text[i];
	str.replace (QRegExp ("<TX>"), "\001");
	str.replace (QRegExp ("<RX>"), "\002");

	str.replace (QRegExp ("<MYNAME>"), config.personals.name);
	str.replace (QRegExp ("<MYCALL>"), config.personals.call);
	str.replace (QRegExp ("<MYQTH>"), config.personals.qth);

		str.replace (QRegExp ("<BAND>"), logbook->getBand());
		str.replace (QRegExp ("<CALL>"), logbook->getCall());
		str.replace (QRegExp ("<NAME>"), logbook->getName());
		str.replace (QRegExp ("<QTH>"), logbook->getQth());	
		str.replace (QRegExp ("<RSTR>"), logbook->getRstr());
		str.replace (QRegExp ("<RSTS>"), logbook->getRsts());

		if (str.contains ("<CALLCHECKON>")) {
			kpsk->callCheckBox->setChecked(true);
 	   str.replace (QRegExp ("<CALLCHECKON>"), "");
			}
		if (str.contains ("<CALLCHECKOFF>")) {
			kpsk->callCheckBox->setChecked(false);
	    str.replace (QRegExp ("<CALLCHECKOFF>"), "");
			}

	kpsk->transmitText (str);
}

void fixText::setLabels ()
{
	int i;
	for (i=0;i<12;++i) {
		button[i]->setText (config.fixtext.label[i]);
		button[i]->setAccel (Key_F1 + i);
	}
}
