#####################################################################
#
#	Author : Kushal Das
#	Copyright (c)  2006 Kushal Das
#	kushal@fedoraproject.org
#	
#	Copyright: See COPYING file that comes with this distribution
#
#
#####################################################################

from kphotobymail_con import kphotobymail_con
import cPickle as p
import os

class config(kphotobymail_con):
	'''Configuration class'''
	def __init__(self,parent):
		kphotobymail_con.__init__(self,parent)
		self.confFile = os.path.join(os.path.join(os.path.expanduser('~'), ".kphotobymail"),'kphotobymail.data')
		f = file(self.confFile)
		data = p.load(f)
		f.close()
		self.smtpTxt.setText(data['host'])
		self.userTxt.setText(data['user'])
		self.passwdTxt.setText(data['password'])
		self.mailTxt.setText(data['mail'])
		self.portTxt.setText(data['port'])
		self.fromTxt.setText(data['from'])
		
	
	def save(self):
		'''Override the save method'''
		data = {}
		data['host']=str(self.smtpTxt.text())
		data['user']=str(self.userTxt.text())
		data['password']=str(self.passwdTxt.text())
		data['mail']=str(self.mailTxt.text())
		data['port']=str(self.portTxt.text())
		data['from']=str(self.fromTxt.text())
		f = file(self.confFile,'w')
		p.dump(data,f)
		f.close()