/*
 * Copyright (C) 2006 Bernhard Beschow <bbeschow @ cs.tu-berlin.de>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */
#include "thinklightpreferences.h"

#include "thinklightconfig.h"

#include <kgenericfactory.h>

#include <qlayout.h>

typedef KGenericFactory<ThinkLightPreferences> ThinkLightPreferencesFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kopete_thinklight, ThinkLightPreferencesFactory( "kcm_kopete_thinklight" )  )

ThinkLightPreferences::ThinkLightPreferences( QWidget *parent, const char*, const QStringList &args ) :
	KCModule( ThinkLightPreferencesFactory::instance(), parent, args ),
	m_ui( this )
{
	( new QVBoxLayout( this ) )->addWidget( &m_ui );

	addConfig( ThinkLightConfig::self(), &m_ui );

	load();
}


