/***************************************************************************
 *   Copyright (C) 2006 by Conrad Hoffmann                                 *
 *   conrausch@gmx.de                                                      *
 *   http://conrausch.doesntexist.org                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef KOPETEDESKLISTGROUP_H
#define KOPETEDESKLISTGROUP_H

#include <qlabel.h>
#include <qdict.h>

class QVBoxLayout;
class KRootPixmap;
namespace Kopete
{
	class Group;
	class MetaContact;
}
class KopeteDesklistItem;
class KopeteDesklistRootWidget;

class KopeteDesklistGroup : public QLabel
{
	Q_OBJECT

public:
	KopeteDesklistGroup( Kopete::Group* group, QWidget* parent = 0, const char* name = 0 );
	~KopeteDesklistGroup();

	void setExpanded( bool expanded );
	bool isExpanded();
	QString getDisplayName();

signals:
	void stateChanged();

protected:
	void mouseDoubleClickEvent( QMouseEvent* e );

private:
	Kopete::Group* m_group;
	bool m_isExpanded;
};

#endif
