/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "ServerDialog.h"

ServerDialog::ServerDialog()
{
    QLabel *label = new QLabel(tr("<strong>KontrolPack TCP/IP Server Mode :<br /> Open Source Network Manager</strong>"), this);
    QLabel *labelIp = new QLabel(tr("Server address :"), this);
    QLabel *labelPort = new QLabel(tr("Server port :"), this);
    ipAddress =  new QLineEdit(this);
    port = new QLineEdit(this);
    QHostInfo hostInfo = QHostInfo::fromName(QHostInfo::localHostName());
    QList<QHostAddress> addresses = hostInfo.addresses();
    if (!addresses.isEmpty()) {
                    for (int i=0; i < addresses.size(); i++) {
                            QHostAddress address = addresses.at(i);
                            if (address.toString().length() <= 15)
                                    ipAddress->setText(address.toString());
                    }
    }
    QPushButton *button = new QPushButton(tr("Start/Stop server"));
    button->setMinimumHeight(70);
    QFrame *upFrame = new QFrame( this );
    upFrame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    QFrame *downFrame = new QFrame( this );
    downFrame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    port->setText("17984");
    QGridLayout *layout = new QGridLayout;
    layout->addWidget(label, 0, 0, 1, 2);
    layout->addWidget(upFrame, 1, 0, 1, 2);
    layout->addWidget(labelIp, 2, 0);
    layout->addWidget(ipAddress, 2, 1);
    setWindowTitle(tr("Server settings"));
    setWindowIcon(QIcon(":/icons/kontrol-icon.png"));
    layout->addWidget(labelPort, 3, 0);
    layout->addWidget(port, 3, 1);
    layout->addWidget(downFrame, 4, 0, 1, 2);
    layout->addWidget(button, 5, 0, 6, 2);
    setLayout(layout);
    connect(button, SIGNAL(clicked()), this, SLOT(hideDialogBox()));
}

void ServerDialog::hideDialogBox()
{
      if (ipAddress->text() != "")
	{
	      if (port->text() != "")
		{
                        emit startedServer(ipAddress->text(), port->text());
			this->hide();
		} else {
                        QMessageBox::information(this, tr("Warning"), tr("Input a port number in the field above to connect."));
		}
	} else {
                QMessageBox::information(this, tr("Warning"), tr("Input an IP address in the field above to connect."));
	}
}

void ServerDialog::centerOnScreen()
{
  QDesktopWidget screen;

  QRect screenGeom = screen.screenGeometry(this);

  int screenCenterX = screenGeom.center().x();
  int screenCenterY = screenGeom.center().y();

  move(screenCenterX - width () / 2,
       screenCenterY - height() / 2);
}

void ServerDialog::showServerSettingsDialog()
{
    this->exec();
}

