/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "MainWindow.h"

MainWindow::MainWindow()
{
	//init variables
	serverIpAddress = new QString("127.0.0.1");
	serverPort = new QString ("17984");
	server = new Server(this);
	status = false;
        isExecuting = false;
	aboutDialog = new AboutDialog();
        loading = new LoadingWidget();
	scriptEditorDialog = new ScriptEditorDialog;
	ipBlackList = new IpBlackList;
	setWindowIcon(QIcon(":/icons/kontrol-icon.png"));
	commandsStringList = QStringList();
	index = 0;
        isFileTransferring = false;
	commandModel = new QStringListModel(commandsStringList);
	contextStringList = QStringList();
	QString path = QDir::homePath();
	#ifdef WIN32
	path.replace(QString("/"), QString("\\"));
	#else
	#endif
	contextStringList.append(path);
        QString title = tr("KontrolPack ") + QString(VERSION) + tr(" : Open source network manager [TCP/IP server mode] ");
	setWindowTitle(title);
	contextModel = new QStringListModel(contextStringList);

	// Tray icon
	createActions();
	createTrayIcon();
	trayIcon->setIcon(QIcon(":/icons/kontrol-icon.png"));
        trayIcon->setToolTip(tr("KontrolPack: Open source network manager."));
	QSystemTrayIcon::MessageIcon icon = QSystemTrayIcon::MessageIcon(1);
        trayIcon->showMessage(tr("JKontrol"), tr("Open source network manager"), icon, 5000);
	trayIcon->show();
	
	// Menus creation
        QMenu *fileMenu = menuBar()->addMenu(tr("&File"));
	QMenu *shellMenu = menuBar()->addMenu(tr("&Shell"));
	QMenu *editMenu = menuBar()->addMenu(tr("&Settings"));
	QMenu *displayMenu = menuBar()->addMenu(tr("&Display"));
        QMenu *windowMenu = menuBar()->addMenu(tr("&Window"));
	QMenu *aboutMenu = menuBar()->addMenu(tr("&About"));

	QAction *startStopServerAction = fileMenu->addAction(tr("&Start/Stop server"));
	startStopServerAction->setShortcut(QKeySequence("Ctrl+T"));
	startStopServerAction->setIcon(QIcon(":/icons/connection.png"));

	QAction *switchModeAction = fileMenu->addAction(tr("&Switch KontrolPack Mode Client/Server"));
	switchModeAction->setShortcut(QKeySequence("Ctrl+S"));
        switchModeAction->setIcon(QIcon(":/icons/go-jump.png"));
	
	QAction *execAction = shellMenu->addAction(tr("&Send command"));
	execAction->setShortcut(QKeySequence("Return"));
        execAction->setIcon(QIcon(":/icons/cmd2.png"));
    
	QAction *execForAllAction = shellMenu->addAction(tr("&Send command to all"));
	execForAllAction->setShortcut(QKeySequence(""));
	execForAllAction->setIcon(QIcon(":/icons/radio2.png"));

	QAction *commandUpAction = shellMenu->addAction(tr("&Previous command"));
	commandUpAction->setShortcut(QKeySequence("Up"));
	commandUpAction->setIcon(QIcon(":/icons/list-add.png"));

	QAction *showSettingsAction = editMenu->addAction(tr("&Server settings"));
	showSettingsAction->setIcon(QIcon(":/icons/prefs.png"));

	QAction *clearAction = shellMenu->addAction(tr("&Clear command"));
	clearAction->setIcon(QIcon(":/icons/clear.png"));
	
	QAction *commandDownAction = shellMenu->addAction(tr("&Next command"));
	commandDownAction->setShortcut(QKeySequence("Down"));
	commandDownAction->setIcon(QIcon(":/icons/list-remove.png"));
	
	QAction *showCommandsDockAction = displayMenu->addAction(tr("&Show commands historic"));
	showCommandsDockAction->setShortcut(QKeySequence("Ctrl+C"));
	showCommandsDockAction->setIcon(QIcon(":/icons/application-certificate.png"));

	QAction *showContextDockAction = displayMenu->addAction(tr("&Show context historic"));
	showContextDockAction->setShortcut(QKeySequence("Ctrl+P"));
	showContextDockAction->setIcon(QIcon(":/icons/gnome-system.png"));

	QAction *networkOverviewAction = displayMenu->addAction(tr("&Network overview"));
	networkOverviewAction->setShortcut(QKeySequence("Ctrl+N"));
	networkOverviewAction->setIcon(QIcon(":/icons/network-map.png"));

	QAction *dnsResolverAction = displayMenu->addAction(tr("&DNS Resolver"));
	dnsResolverAction->setShortcut(QKeySequence("Ctrl+D"));
	dnsResolverAction->setIcon(QIcon(":/icons/applications-internet.png"));

	QAction *ipBlackListAction = displayMenu->addAction(tr("&IPs Filter"));
	ipBlackListAction->setShortcut(QKeySequence("Ctrl+D"));
	ipBlackListAction->setIcon(QIcon(":/icons/network-error.png"));

	QAction *scriptAction = fileMenu->addAction(tr("&Script editor"));
	scriptAction->setShortcut(QKeySequence("Ctrl+S"));
	scriptAction->setIcon(QIcon(":/icons/media-flash.png"));

	QAction *aboutAction = aboutMenu->addAction(tr("&About"));
	aboutAction->setShortcut(QKeySequence("Ctrl+A"));
	aboutAction->setIcon(QIcon(":/icons/about.png"));

	QAction *quitAction = fileMenu->addAction(tr("&Quit"));
	quitAction->setShortcut(QKeySequence("Ctrl+Q"));
	quitAction->setIcon(QIcon(":/icons/exit.png"));

        QAction *fullScreenAction = windowMenu->addAction(tr("&Full Screen"));
        fullScreenAction->setShortcut(QKeySequence("Ctrl+Shift+F11"));
        //fullScreenAction->setIcon(QIcon(":/icons/exit.png"));


	QDir currentDir = QDir(path);
	QStringList pathList = currentDir.entryList(QDir::Dirs, QDir::Name);
	pathPosssibility = QStringList();
        for (int j = 0; j < pathList.size(); ++j) {
            pathPosssibility.append(QString("cd ") + pathList.at(j));
        }
	
	// Main toolBar
        QToolBar *fileToolBar = addToolBar(tr("Shell"));
	fileToolBar->addAction(startStopServerAction);
	fileToolBar->addSeparator();
	fileToolBar->addAction(execAction);
	fileToolBar->addAction(execForAllAction);
	fileToolBar->addSeparator();
	fileToolBar->addAction(scriptAction);
	fileToolBar->addSeparator();
	fileToolBar->addAction(clearAction);
	fileToolBar->addAction(commandUpAction);
	fileToolBar->addAction(commandDownAction);
        fileToolBar->addSeparator();
	QLabel *label= new QLabel(this);
	label->setPixmap(QPixmap(":/icons/kontrol-icon-small.png"));
	label->move(0, 2000);
	fileToolBar->addWidget(label);

	QToolBar *serverToolBar = new QToolBar();
	addToolBar (Qt::LeftToolBarArea, serverToolBar);
	serverToolBar->addAction(networkOverviewAction);
	serverToolBar->addAction(dnsResolverAction);
	serverToolBar->addAction(ipBlackListAction);
	serverToolBar->addAction(showSettingsAction);
	serverToolBar->addAction(switchModeAction);
	serverToolBar->setOrientation(Qt::Vertical);
	
	// Docks creation
	dock = new QDockWidget(tr("Commands historic"), this);
	contextDock = new QDockWidget(tr("Paths historic"), this);
	addDockWidget(Qt::LeftDockWidgetArea, dock);
	addDockWidget(Qt::TopDockWidgetArea, contextDock);
	commandsList = new QListCyborgWidget;
	contextsList = new QListCyborgWidget;
	contextsList->setModel(contextModel);

	dock->setWidget(commandsList);
	contextDock->setWidget(contextsList);
	dock->hide();
	contextDock->hide();
	
	// Central zone creation
	centralWindow = new CentralWindow;
	setCentralWidget(centralWindow);
	
        progressBar = new QProgressBar(this);
	//StatusBar creation
	toolBar = statusBar();
	toolBar->showMessage(tr("http://www.kontrolpack.com/"));
        toolBar->addPermanentWidget(progressBar);

        //signals and slots connections
	connect(switchModeAction, SIGNAL(triggered()), this, SLOT(switchMode()));
        connect(fullScreenAction, SIGNAL(triggered()), this, SLOT(fullScreenMode()));
        connect(ipBlackListAction, SIGNAL(triggered()), this, SLOT(showBlackListDialog()));
	connect(networkOverviewAction, SIGNAL(triggered()), centralWindow->serverHome, SLOT(showNetworkMap()));
	connect(dnsResolverAction, SIGNAL(triggered()), centralWindow->serverHome, SLOT(showDNSResolver()));
	connect(showSettingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
	connect(this, SIGNAL(commandFromScriptEditorNotExecuted()), scriptEditorDialog, SLOT(setIndexToZero()));
	connect(centralWindow, SIGNAL(startNextThread()), scriptEditorDialog, SLOT(startNextThread()));
	connect(execForAllAction, SIGNAL(triggered()), this, SLOT(sendCommandToAllThread()));
	connect(startStopServerAction, SIGNAL(triggered()), this, SLOT(startStopServer()));	 	    
	connect(scriptAction, SIGNAL(triggered()), this, SLOT(scriptEditorAction()));				
	connect(centralWindow, SIGNAL(sendContext(QString)), this, SLOT(displayContext(QString)));
	connect(this, SIGNAL(appendCommandToDock(QString)), this, SLOT(appendToDock(QString)));
	connect(centralWindow, SIGNAL(notifyToolBar()), this, SLOT(displayUrl()));
	connect(quitAction, SIGNAL(triggered()), qApp, SLOT(quit()));
	connect(execAction, SIGNAL(triggered()), centralWindow, SLOT(exec()));
	connect(showCommandsDockAction, SIGNAL(triggered()), this, SLOT(displayCommandsDock()));
	connect(showContextDockAction, SIGNAL(triggered()), this, SLOT(displayContextDock()));
	connect(aboutAction, SIGNAL(triggered()), this, SLOT(displayAbout()));
	connect(commandsList, SIGNAL(clicked(QModelIndex)), this, SLOT(clicCommandSelection()));
	connect(contextsList, SIGNAL(clicked(QModelIndex)), this, SLOT(clicContextSelection()));
	connect(trayIcon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)), this, SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));
	connect(this, SIGNAL(setCommandLine(QString)), centralWindow, SLOT(setCommand(QString)));
	connect(centralWindow, SIGNAL(sendCommandToClient(QString, int)), this, SLOT(sendCommandToThread(QString, int)));
	connect(scriptEditorDialog, SIGNAL(sendCommand(QString)), this, SLOT(sendSpecificCommandToAllThread(QString)));	

	connect(server, SIGNAL(sendClientParameters(QStringList, int)), this, SLOT(getClientParameters(QStringList, int)));
	connect(server, SIGNAL(sendClientContextToGui(QStringList, int)), centralWindow, SLOT(getClientContext(QStringList, int)));
	connect(server, SIGNAL(sendResults(QString*, int)), centralWindow, SLOT(displayResults(QString*, int)));
	connect(server, SIGNAL(removeTab(QString, int)), this, SLOT(removeTab(QString, int)));
	connect(this, SIGNAL(sendClientParameters(QStringList, int)), centralWindow, SLOT(getClientParameters(QStringList, int)));
	connect(this, SIGNAL(sendRemoveTab(QString, int)), centralWindow, SLOT(removeTab(QString, int)));
	connect(server, SIGNAL(errorOccuredWhileStartingServer(QString)), this, SLOT(errorOccuredWhileStartingServer(QString)));
	connect(commandUpAction, SIGNAL(triggered()), centralWindow, SLOT(getUpCommand()));	
	connect(commandDownAction, SIGNAL(triggered()), centralWindow, SLOT(getDownCommand()));	
	connect(clearAction, SIGNAL(triggered()), centralWindow, SLOT(clearCommand()));
	connect(this, SIGNAL(displayStartedServer(QString, QString, bool)), centralWindow, SLOT(displayStartedServer(QString, QString, bool)));
	connect(centralWindow, SIGNAL(refreshMainWindowTitle()), this, SLOT(refreshServerTitle()));
	connect(server, SIGNAL(warning(QString)), this, SLOT(warning(QString)));
        connect(server, SIGNAL(displayFileTransfered(QString)), this, SLOT(displayFileTransfered(QString)));
        connect(server, SIGNAL(bytesSent(int)), this, SLOT(bytesSent(int)));
        connect(server, SIGNAL(bytesSent(int)), loading, SLOT(bytesSent(int)));
        connect(centralWindow, SIGNAL(sendFileToRemoteClient(QString, int)), this, SLOT(sendFilePathToFileServer(QString, int)));
        connect(centralWindow, SIGNAL(askFileFromRemoteClient(QString, int)), this, SLOT(askFileFromRemoteClient(QString, int)));
        connect(centralWindow, SIGNAL(resetProgressBar(int)), this, SLOT(resetProgressBar(int)));
        connect(server, SIGNAL(fileSent(int)), this, SLOT(fileSent(int)));
        connect(server, SIGNAL(clientBytesSentSignal(int, int)), this, SLOT(clientBytesSent(int, int)));
        connect(server, SIGNAL(endDownloadSignal(int)), this, SLOT(fileSent(int)));
        connect(this, SIGNAL(displayStartedServer(QString, QString, bool)), centralWindow, SLOT(displayStartedServer(QString, QString, bool)));
        connect(this, SIGNAL(fileSentSignal(int)), centralWindow, SLOT(fileSent(int)));
}

void MainWindow::sendCommandToThread(QString command, int clientNbr)
{
    progressBar->setMaximum(100);
    progressBar->setValue(50);
    isExecuting = true;
    server->send_to_client(command, clientNbr);
    appendToDock(command);
    centralWindow->displayLoading(clientNbr);
}

void MainWindow::askFileFromRemoteClient(QString filePath, int clientNbr)
{
    server->ask_file_from_client(filePath, clientNbr);  
    isFileTransferring = true;
}

void MainWindow::sendFilePathToFileServer(QString filePath, int clientNbr)
{
    QFile f(filePath);
    QByteArray bytes;
    if (!f.open(QIODevice::ReadOnly))
    {
        emit fileSent(clientNbr);
        return;
    }
    while (!f.atEnd())
    {
        bytes = f.readAll();
    }
    f.close();
    int size = bytes.size();
    progressBar->setMaximum(size + 25);
    progressBar->setValue(25);
    loading->sizeLabel->setText("0/" + QString::number(size));
    loading->totalSize = size;
  #ifdef WIN32
         QString c = "\\";
  #elif defined (linux)
         QString c = "/";
  #elif defined __APPLE__
         QString c = "/";
  #endif
    QString name = filePath.midRef(filePath.lastIndexOf(c) + 1).toString();
    server->send_file_to_client(name, size, clientNbr);
  #ifdef WIN32
  #elif defined (linux)
  #elif defined __APPLE__
         loading->show();
  #endif
    isFileTransferring = true;
    server->sendFile(filePath, clientNbr);
}

void MainWindow::showBlackListDialog()
{
    ipBlackList->exec();
}

void MainWindow::sendCommandToAllThread()
{
    QString command = centralWindow->getCommand();
    if (command != "")
    {
        progressBar->setMaximum(100);
        progressBar->setValue(25);
        appendToDock(command);
        isExecuting = true;
        server->send_to_all_client(command);
    } else {
        QMessageBox::information(this, tr("Warning"), tr("Input a command in the field below to start executing commands."));
    }
}

void MainWindow::sendSpecificCommandToAllThread(QString command)
{
    if (centralWindow->getSelectedClient() != -1)
    {
        progressBar->setMaximum(100);
        progressBar->setValue(25);
        timer = new QTimer(this);
        timer->setInterval(60);
        connect(timer, SIGNAL(timeout()), this, SLOT(incrementProgressBar()));
        timer->start();
        appendToDock(command);
        isExecuting = true;
        server->send_to_all_client(command);
    } else {
        emit commandFromScriptEditorNotExecuted();
        QMessageBox::information(this, tr("Warning"), tr("Select a tab corresponding to a specific client."));
    }
}

void MainWindow::displayPathPossibility(QStringList list)
{
	pathPosssibility.clear();
	 for (int j = 0; j < list.size(); ++j) {
                pathPosssibility.append("cd " + list.at(j));
	}
	emit sendPathListForCompletion(pathPosssibility);
}

void MainWindow::execCommandFromDialog(QString commandToExec)
{
	emit sendCommand(commandToExec);
}

void MainWindow::displayContext(QString msg) 
{
	contextStringList.append(msg);
	contextModel =  new QStringListModel(contextStringList);
	contextsList->setModel( new QStringListModel(contextStringList));
}

void MainWindow::scriptEditorAction()
{
	scriptEditorDialog->exec();
}

void MainWindow::displayUrl() 
{
	toolBar->showMessage(tr("http://www.kontrolpack.com/"));
}

void MainWindow::appendToDock(QString msg) 
{
	if (commandsStringList.size() == 2)
            dock->show();
	commandsStringList.append(msg);
	index =  commandsStringList.size() - 1;
	commandModel->setStringList(commandsStringList);
	commandsList->setModel(commandModel);
	displayUrl();
}

void MainWindow::displayContextDock() 
{
	contextDock->show();
}

void MainWindow::displayCommandsDock() 
{
	dock->show();
}

void MainWindow::displayAbout() 
{
	aboutDialog->exec();
}

void MainWindow::clicCommandSelection()
{
        QVariant elementSelectionne = commandModel->data(commandsList->selectionModel()->currentIndex(), Qt::DisplayRole);
	emit setCommandLine(elementSelectionne.toString());
}

void MainWindow::clicContextSelection()
{
    QItemSelectionModel *selection = contextsList->selectionModel();
    QModelIndex indexElementSelectionne = selection->currentIndex();
	QVariant elementSelectionne = contextModel->data(indexElementSelectionne, Qt::DisplayRole);
	QString path = QString("cd ");
	path.append(elementSelectionne.toString());
	emit setCommandLine(path);
}

void MainWindow::createActions()
{
    minimizeAction = new QAction(tr("Mi&nimize KontrolPack"), this);
    connect(minimizeAction, SIGNAL(triggered()), this, SLOT(hide()));

    maximizeAction = new QAction(tr("Ma&ximize KontrolPack"), this);
    connect(maximizeAction, SIGNAL(triggered()), this, SLOT(showMaximized()));

    aboutTrayIConAction = new QAction(tr("About KontrolPack"), this);
    connect(aboutTrayIConAction, SIGNAL(triggered()), this, SLOT(displayAbout()));

    qAction = new QAction(tr("&Quit server mode"), this);
    connect(qAction, SIGNAL(triggered()), qApp, SLOT(quit()));
}

void MainWindow::createTrayIcon()
{
    trayIconMenu = new QMenu(this);
    trayIconMenu->addAction(minimizeAction);
    trayIconMenu->addAction(maximizeAction);
    trayIconMenu->addSeparator();
    trayIconMenu->addAction(aboutTrayIConAction);
    trayIconMenu->addSeparator();
    trayIconMenu->addAction(qAction);

    trayIcon = new QSystemTrayIcon(this);
    trayIcon->setContextMenu(trayIconMenu);
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    if (trayIcon->isVisible()) {
        hide();
        event->ignore();
    } else {
        server->send_to_all_client("\n");
        server->stop_server();
    }
}

void MainWindow::iconActivated(QSystemTrayIcon::ActivationReason reason)
{
    switch (reason) {
    case QSystemTrayIcon::Trigger:
		if (this->isVisible()) {
			hide();
		} else {
			show();
		}
		 break;
	case QSystemTrayIcon::DoubleClick:
		break;
    case QSystemTrayIcon::MiddleClick:
                QMessageBox::information(this, tr("About KontrolPack"), tr("KontrolPack  : A TCP/IP Network Manager."));
        break;
    default:
		;
    }
}

void MainWindow::startStopServer()
{
	if (status)
	{
		emit displayStartedServer(*serverIpAddress, *serverPort, false);
                server->stop_server();
		status = false;
	}
	else
	{
                emit displayStartedServer(*serverIpAddress, *serverPort, true);
		if (!server->listen(QHostAddress(qPrintable(*serverIpAddress)), serverPort->toInt())) {
                        errorOccuredWhileStartingServer(QString(tr("The server needs to be restarted.")));
		}
		status = server->getServerStatus();
	}
}

void MainWindow::showSettings()
{
	emit showServerSettingsDialog();
}


void MainWindow::startedServer(QString ipAddress, QString port)
{
	serverIpAddress = new QString(ipAddress);
	serverPort = new QString(port);
	if (status)
	{
		emit displayStartedServer(ipAddress, port, false);
                server->stop_server();
		status = false;
	}
	else
	{
                emit displayStartedServer(ipAddress, port, true);
		if (!server->listen(QHostAddress(ipAddress), port.toInt())) {
                        errorOccuredWhileStartingServer(QString(tr("The server needs to be restarted.")));
		}
		status = true;
	}	
}

void MainWindow::errorOccuredWhileStartingServer(QString msg)
{
    QMessageBox::information(this, tr("Warning"), msg);
    server->stop_server();
    status = false;
    emit displayStartedServer(QString("127.0.0.1"), QString("17984"), false);
}

void MainWindow::warning(QString msg)
{

    QMessageBox::information(this, tr("Warning"), msg);
}

void MainWindow::displayFileTransfered(QString msg)
{
    isFileTransferring = false;
    if (msg.startsWith("DOWNLOADING", Qt::CaseSensitive)) {
  #ifdef WIN32
  #elif defined (linux)
  #elif defined __APPLE__
         loading->show();
  #endif
     } else
    {
        QMessageBox::information(this, tr("File transfert succeeded"), msg);
    }
}

void MainWindow::getClientParameters(QStringList parameters, int clientNbr)
{
    emit sendClientParameters(parameters, clientNbr);
}

void MainWindow::removeTab(QString title, int clientNbr)
{
        setWindowTitle(tr("KontrolPack ") + QString(VERSION) + tr(" : Open source network manager [TCP/IP server mode] ") + QString::number(server->get_client_number()) + tr(" connected clients."));
        emit sendRemoveTab(title, clientNbr);
}

void MainWindow::refreshServerTitle()
{
        setWindowTitle(tr("KontrolPack ") + QString(VERSION) + tr(" : Open source network manager [TCP/IP server mode] ") + QString::number(server->get_client_number()) + tr(" connected clients."));
}

void MainWindow::switchMode()
{
	XmlDataStore::saveStartUpMode(QString("NONE"));
        QMessageBox::information(this, tr("Switch KontrolPack Mode Information"), tr("Your modification is saved. Please, restart KontrolPack in order to choose another mode."));
}

void MainWindow::resetProgressBar(int clientNbr)
{
    isExecuting = false;
    emit fileSentSignal(clientNbr);
    progressBar->setValue(0);
}

void MainWindow::fileSent(int clientNbr)
{
    progressBar->setValue(0);
  #ifdef WIN32
  #elif defined (linux)
  #elif defined __APPLE__
         loading->hide();
  #endif
    emit fileSentSignal(clientNbr);
}

void MainWindow::incrementProgressBar()
{
    progressBar->setValue(progressBar->value() + 10);
}

void MainWindow::bytesSent(int sizeSent)
{
    progressBar->setValue(progressBar->value() + sizeSent);
}

void MainWindow::clientBytesSent(int sizeSent, int fileSize)
{
    progressBar->setMaximum(fileSize);
    progressBar->setValue(progressBar->value() + sizeSent);
}

void MainWindow::fullScreenMode()
{
    if (this->windowState() != Qt::WindowFullScreen)
        showFullScreen();
    else
        showMaximized();
}
