/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "LoadingWidget.h"

LoadingWidget::LoadingWidget()
{
    label = new QLabel(tr("Loading file... Please wait until the end of the file transfer. <br />This dialog box will be destroyed as soon as the file is uploaded. "), this);
    sizeLabel = new QLabel("", this);

    QGridLayout *layout = new QGridLayout;
    layout->addWidget(label, 0, 0);
    layout->addWidget(sizeLabel, 2, 0);
    setWindowTitle(tr("Sharing file"));
    setWindowIcon(QIcon(":/icons/kontrol-icon.png"));
    setLayout(layout);
    setModal(false);
}


void LoadingWidget::bytesSent(int sizeSent)
{
    sizeLabel->setText(QString::number(sizeSent) + "/" + QString::number(totalSize));
}

void LoadingWidget::hideDialogBox()
{
	this->hide();
}


