/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include <QDialog>
#include <QGridLayout>
#include <QLabel>
#include <QLineEdit>
#include <QListView>
#include <QPushButton>
#include <QStringList>
#include <QStringListModel>
#include <QDir>
#include <QMessageBox>
#include "datastore/XmlDataStore.h"

class IpBlackList : public QDialog
{
    Q_OBJECT

public:
        IpBlackList();
        int index;
        QPushButton *addButton;
        QPushButton *clearButton;
        QPushButton *closeButton;
        QPushButton *deleteButton;
        QListView *commandList;
        QLabel *scannerPortLabel;
        QLineEdit *commandLine;
        QStringList ipStringList;
        QStringListModel *scriptEditorModel;
protected:
    void closeEvent(QCloseEvent *event);

public slots:
    void addCommandToList();
    void deleteCommand();
    void clearCommandsList();

    void setIndexToZero();
signals:
        void sendCommand(QString commands);
private:

};

