/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include<QWidget>
#include<QString>
#include<QTextEdit>
#include<QStringListModel>
#include<QLabel>
#include <QGridLayout>
#include <QPushButton>
#include <QDir>
#include "QListCyborgWidget.h"
#include <QStringList>
#include <QGroupBox>
#include <QMessageBox>
#include <QFileDialog>
#include <QFileSystemModel>
#include <QStandardItemModel>
#include <QFileIconProvider>
#include <QStandardItem>
#include <QList>
#include <QTimer>

class FileTransfertClientWidget : public QWidget
{
    Q_OBJECT
    public:
    QTextEdit *textBrowser;
    QLabel *localPath;
    QString localStringPath;
    QStringList params;
    QLabel *path;
    QLabel *remotePath;
    QStringListModel *localFilesModel;
    QStringListModel *remoteFilesModel;
    QStandardItemModel *remoteFilesIconModel;
    QList<QStandardItem *> *remoteFilesIconList;
    QStringList localFilesList;
    QStringList remoteFilesList;
    QStringList remoteFoldersList;
    QListCyborgWidget *remoteList;
    QListCyborgWidget *localList;
    QPushButton *getButton;
    QPushButton *sendButton;
    QFileIconProvider *iconprovider;
    int nbr;
    FileTransfertClientWidget(int clientNbr, QLabel *pict, QStringList parameters, QWidget *parent);

public slots:
    void clicRemoteFileSelection();
    void clicLocalFileSelection();
    void openFolderDialog();
    void refreshFilesList();
    void doubleClicFolder();
    void fileSent(int clientNbr);
    void fileUploaded(int clientNbr);

signals:
    void setCommandLine(QString selection);
    void sendFileToRemoteClient(QString filePath, int clientNbr);
    void getFileFromRemoteClient(QString filePath, int clientNbr);
    void changeDirectory(QString folderName, int clientNbr);
protected:


};


