/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kglobal.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <klocale.h>

#include <qlabel.h>
#include <qtoolbutton.h>
#include <qbuttongroup.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qfileinfo.h>
#include <qdir.h>

#include "kompileuserinstallbase.h"
#include "kompileuserinstall.h"

KompileUserInstall::KompileUserInstall(QWidget *parent, const char *name)
    : KDialogBase(parent, name,true, tr2i18n("Warning: Super User Privileges Required"),
                  KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
  base = new KompileUserInstallBase( this );
  setMainWidget(base);
  base->pxmWarning->setPixmap(KGlobal::iconLoader()->loadIcon("messagebox_warning", KIcon::NoGroup, 48));
  base->btnBrowse->setPixmap(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));
  connect(base->btnBrowse,SIGNAL(clicked()),this,SLOT(btnBrowse_clicked()));
  connect(base->bgUserChoice,SIGNAL(clicked(int)),this,SLOT(bgUserChoice_clicked(int)));
  selected = -1;
}

void KompileUserInstall::bgUserChoice_clicked(int)
{
  base->gbDirectory->setEnabled(base->bgUserChoice->selectedId() == 2);
}

void KompileUserInstall::btnAbort_clicked()
{
  reject();
}

void KompileUserInstall::btnBrowse_clicked()
{
  base->txtPath->setText(KFileDialog::getExistingDirectory(base->txtPath->text(), this, tr2i18n("Select installation directory")));
}

int KompileUserInstall::getInstallationMethod()
{
  return selected;
}

QString KompileUserInstall::getInstallationDirectory()
{
  return base->txtPath->text();
}

void KompileUserInstall::accept()
{
  btnInstall_clicked();
  KDialogBase::accept();
}

void KompileUserInstall::btnInstall_clicked()
{
  selected = base->bgUserChoice->selectedId();

  if (selected == 2)
  {
    QFileInfo file(base->txtPath->text());

    if (!file.exists())
    {
      QDir  * dir = new QDir();
      if (!dir->mkdir(base->txtPath->text()))
      {
        KMessageBox::error(this, tr2i18n("Kompile is unable to create the specified destination directory.\nYou must specify a writable directory for binaries install."), tr2i18n("Invalid Directory Selected"));
      }

      delete dir;
      selected = -1;
      return;
    }

    if (!file.isDir())
    {
      KMessageBox::error(this, tr2i18n("The installation path selected seems to be a file.\nYou must specify a writable directory for binaries install."), tr2i18n("Invalid Directory Selected"));
      selected = -1;
      return;
    }

    if (!file.isWritable())
    {
      KMessageBox::error(this, tr2i18n("You don't have permissions to write into the installation path selected.\nYou must specify a writable directory for binaries install."), tr2i18n("Invalid Directory Selected"));
      selected = -1;
      return;
    }
  }

}


#include "kompileuserinstall.moc"
