/***************************************************************************
 *   Copyright (C) 2005 by Sergio Cambra                                   *
 *   runico@users.berlios.de                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qmessagebox.h>
#include <qdir.h>
#include <klocale.h>
#include <qmessagebox.h>
#include <kdebug.h>

#include "kommandod.h"
#include "configuration.h"

KommandoDaemon::KommandoDaemon(const QCString &name)
    : KDEDModule(name), Shortcut(this,"Shortcut"), kommandoWin(0)
{
    Config& config = Config::getSingleton();
    config.readConfigFile();

    kommandoWin = new Kommando();
    config.toKommandoMenu(kommandoWin);

    Shortcut.insert("Toggle", i18n("Toggle"),
                    i18n("This shortcut toggles the visibility of the Kommando menu"),
                    KShortcut(config.Shortcut()), KShortcut(config.Shortcut()),
                    kommandoWin, SLOT( slotGlobAccel() ) );
    Shortcut.setEnabled(true);
    Shortcut.updateConnections();
}

KommandoDaemon::~KommandoDaemon()
{
    delete kommandoWin;
}

void KommandoDaemon::reparseConfiguration()
{
    Config& config = Config::getSingleton();
    if(!config.readConfigFile())
        config.setDefaultValues();

    config.toKommandoMenu(kommandoWin);
    Shortcut.setShortcut("Toggle", config.Shortcut());
    Shortcut.updateConnections();
}

extern "C" {
    KDE_EXPORT KDEDModule *create_kommandod(const QCString &obj)
    {
        return new KommandoDaemon(obj);
    }
};

#include "kommandod.moc"
