<?php
/**
 *
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: init_admin.php 354 2007-04-21 17:44:50Z lordlamer $
 */

if (!isset ($_SERVER['ORIG_PATH_TRANSLATED'])) { $_SERVER['ORIG_PATH_TRANSLATED'] = ''; }
if (!isset ($_SERVER['ORIG_SCRIPT_FILENAME'])) { $_SERVER['ORIG_SCRIPT_FILENAME'] = ''; }
// get base paths
define('KNOWLEDGEROOT_ADMIN_PATH',dirname(str_replace('//','/', str_replace('\\','/', (php_sapi_name()=='cgi' || php_sapi_name()=='isapi' || php_sapi_name()=='cgi-fcgi') && ($_SERVER['ORIG_PATH_TRANSLATED']?$_SERVER['ORIG_PATH_TRANSLATED']:$_SERVER['PATH_TRANSLATED'])? ($_SERVER['ORIG_PATH_TRANSLATED']?$_SERVER['ORIG_PATH_TRANSLATED']:$_SERVER['PATH_TRANSLATED']):($_SERVER['ORIG_SCRIPT_FILENAME']?$_SERVER['ORIG_SCRIPT_FILENAME']:$_SERVER['SCRIPT_FILENAME'])))));
define('KNOWLEDGEROOT_PATH',str_replace('/admin','',KNOWLEDGEROOT_ADMIN_PATH));

$base_path = KNOWLEDGEROOT_PATH;

// get base url for session name
$baseurl = $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'];
preg_match("/(.*\/).*/", $baseurl, $url_arr);

if($url_arr[1] == "") {
	$url_arr[1] = $_SERVER['HTTP_HOST'];
}

// init session
session_name(md5($url_arr[1]));
session_start();

// load required files
require_once($base_path."/include/version.php");
require_once($base_path."/include/function.php");
require_once($base_path."/include/class-knowledgeroot.php");
require_once($base_path."/include/class-knowledgeroot-header.php");
require_once($base_path."/include/class-language.php");
require_once($base_path."/include/class-knowledgeroot-extension.php");
require_once($base_path."/include/class-extension-base.php");
require_once($base_path."/include/class-error.php");
require_once($base_path."/include/class-hooks.php");

// this is the variable where all classes are in
$CLASS = array();

// define global variables
$CLASS['vars'] = $CONFIG;
$CLASS['admin_vars'] = $ADMIN_CONFIG;

// init error
$CLASS['error'] = new knowledgeroot_error();
$CLASS['error']->start($CLASS);

// set base paths
$CLASS['vars']['base_path'] = KNOWLEDGEROOT_PATH;
$CLASS['vars']['admin_base_path'] = KNOWLEDGEROOT_ADMIN_PATH;

// load databaseclass
if($CLASS['vars']['db']['type'] == "mysql") {
	require_once($base_path."/include/class-mysql.php");
}

if($CLASS['vars']['db']['type'] == "mysqli") {
	require_once($base_path."/include/class-mysqli.php");
}

if($CLASS['vars']['db']['type'] == "pgsql") {
	require_once($base_path."/include/class-pgsql.php");
}

if($KNOWLEDGEROOTDB != "PGSQL" && $KNOWLEDGEROOTDB != "MYSQL") {
	echo "WRONG DBTYPE SELECTED!\n";
	exit();
}

// init hooks
$CLASS['hooks'] = new hooks();
$CLASS['hooks']->start($CLASS);

// init databaseclass
$CLASS['db'] = new db();

// connect to database
$CLASS['db']->connect($CLASS['vars']['db']['host'],$CLASS['vars']['db']['user'],$CLASS['vars']['db']['pass'],$CLASS['vars']['db']['database'],$CLASS['vars']['db']['schema'],$CLASS['vars']['db']['encoding']);

// init knowledgerootclass
$CLASS['knowledgeroot'] = new knowledgeroot();
$CLASS['knowledgeroot']->start($CLASS);

// load config from db
$CLASS['vars'] = $CLASS['knowledgeroot']->replace_array($CLASS['vars'], $CLASS['knowledgeroot']->getConfigArr());

// init language
$CLASS['language'] = new language();
$CLASS['language']->start($CLASS,$CLASS['vars']['knowledgeroot']['language']);

// check for opera and konqueror
// this is a short fix beacause the ajaxtree does not work in opera and konqueror
if($CLASS['vars']['menu']['ajax'] == "yes") {
//	if(preg_match("/.*[Kk]onqueror.*/",$_SERVER['HTTP_USER_AGENT']) || preg_match("/.*[Oo]pera.*/",$_SERVER['HTTP_USER_AGENT'])) {
//		$CLASS['vars']['menu']['ajax'] = "no";
//	}
}

// addslashes on GET/POST
$CLASS['knowledgeroot']->addSlashesOnArray($_GET);
$CLASS['knowledgeroot']->addSlashesOnArray($_POST);

// init header
$CLASS['kr_header'] = new knowledgeroot_header();
$CLASS['kr_header']->start($CLASS);

// load extensions
$CLASS['kr_extension'] = new knowledgeroot_extension();
$CLASS['kr_extension']->start($CLASS,1);

// add favicon pointer
$CLASS['kr_header']->addheader("<link rel=\"shortcut icon\" href=\"../favicon.ico\" type=\"image/x-icon\" />");

// add generator
$CLASS['kr_header']->addheader("<meta name=\"generator\" content=\"Knowledgeroot - ".$version."\" />");

// set charset
if($CLASS['vars']['knowledgeroot']['charset'] != "") {
	if($CLASS['vars']['knowledgeroot']['charset'] == "utf8") {
		$charset = "utf-8";
	} else {
		$charset = $CLASS['vars']['knowledgeroot']['charset'];
	}

	header("Content-Type: text/html; charset=".$charset."");
	$CLASS['kr_header']->addheader("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" . $charset . "\" />");
}

// add javascript to htmlheader
$CLASS['kr_header']->addjssrc("../system/javascript/prototype.js");
$CLASS['kr_header']->addjssrc("../system/javascript/scriptaculous.js");
$CLASS['kr_header']->addjssrc("../system/javascript/effects.js");
$CLASS['kr_header']->addjssrc("../system/javascript/dragdrop.js");
$CLASS['kr_header']->addjssrc("../system/javascript/showhide.js");
$CLASS['kr_header']->addjssrc("../system/javascript/ajax-tree.js");
$CLASS['kr_header']->addjssrc("../system/javascript/messagebox.js");

// start all extensions
$CLASS['kr_extension']->start_extensions();

// add hook
$CLASS['hooks']->setHook("init_admin","init","end");
?>
