/***************************************************************************
                          io_base.h  -  description
                             -------------------
    begin                : Tue Jun 18 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IO_BASE_H
#define IO_BASE_H


#include "definitions.h"
#include "resource.h"
#include "command.h"
#include "match_param.h"

#include <qobject.h>
#include <qwidget.h>
/**
  *@author Alexander Wels.
  */

class io_base : public QObject
{
  Q_OBJECT

public:

  enum ioType
  {
    INTERNET = 0,
    LOCAL = 1
  };

  io_base(QWidget *parent=NULL, resource *rsrc=NULL);
  io_base(resource *rsrc);
  io_base(resource *rsrc, int ID);
  virtual               ~io_base();
  int                   getID( void );
  void                  setID( const int ID );
  int                   getType( void );

public slots:
  virtual void          recvCMD(const Command& command) = 0; // sub classes have to implement this

signals:
  virtual void          sendCMD(const Command& command) = 0; // sub classes have to implement this


protected:
  // The knightio object needs to know its ID
  QWidget *myParent;
  int myID;
  resource *myResource;
  ioType myType;
};

#endif
