/***************************************************************************
                          dlg_server.h  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLG_SERVER_H
#define DLG_SERVER_H

#include <kdialogbase.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kfiledialog.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qcheckbox.h>
#include <qstring.h>
#include "definitions.h"
#include "resource.h"

/**
  *@author Troy Corbin Jr.
  */

class dlg_server : public KDialogBase
{
   Q_OBJECT
	public:
													dlg_server(QWidget *parent=0, const char *name=0, resource *Rsrc=0, QString ItemName="" );
													~dlg_server();

	public slots:
		void									slotOk( void );
		void									slotApply( void );
		void									slotCancel( void );
		void									slotLogFileDialog( void );
		void									slotEnableApply( const QString& );
		void									slotStorePass( bool state );
		void									slot_Timeseal( void );

	private:
		serverList::Iterator	serversIT;
		resource							*Resource;
		QString								Name;

		QVBox									*BOX_Parent;
		QHBox									*BOX_URLPort;
		QHBox									*BOX_UNameStore;
		QHBox									*BOX_Pass;

		QGroupBox							*BOX_Name;
		KLineEdit							*EDIT_Name;

		QGroupBox							*BOX_URL;
		KLineEdit							*EDIT_URL;
		
		QGroupBox							*BOX_Port;
		KLineEdit							*EDIT_Port;
		
		QGroupBox							*BOX_UserName;
		KLineEdit							*EDIT_UserName;
		QCheckBox							*CHECK_StorePass;

		QGroupBox							*BOX_Password;
		KLineEdit							*EDIT_Password;
		
		QGroupBox							*BOX_PasswordRetype;
		KLineEdit							*EDIT_PasswordRetype;

		QGroupBox							*GROUP_Timeseal;
			KLineEdit							*EDIT_Timeseal;
				QPushButton					*BUTTON_Timeseal;
		
		QGroupBox							*BOX_LogFile;
		KLineEdit							*EDIT_LogFile;
		QPushButton						*BUTTON_LogFile;
};

#endif
