//
// C++ Implementation: interface
//
// Description:
//
//
// Author: Hugo Parente Lima <hugo.pl@gmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "interface.h"
#include <kapplication.h>
#include <kapp.h>
#include <kconfig.h>

Interface::Interface(KNetStats* parent, const QString& name) : mName(name), mView(0), mParent(parent) {
	update();
}

void Interface::update() {
	bool defaultVisibility = !(mName == "lo" || mName == "sit0");

	KConfig* cfg = kapp->config();
	KConfigGroupSaver groupSaver(cfg, mName);
	bool visible = cfg->readBoolEntry("Monitoring", defaultVisibility);
	if (!visible)
		setVisible(false);
	else if (visible && !mView)
		setVisible(true);
	else if (visible && mView)
		mView->updateViewOptions();
}

void Interface::setVisible(bool visible) {
	if (!visible) {
		delete mView;
		mView = 0;
	} else if (visible && !mView)
		mView = new KNetStatsView(mParent, mName);
}

KNetStatsView::Options Interface::options() {
	if (mView)
		return mView->options();
	else {
		KNetStatsView::Options opt;
		KNetStatsView::readOptions(mName, &opt, false);
		return opt;
	}
}

void Interface::say(const QString& message) {
	if (mView)
		mView->say(message);
}

