/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "propspane.h"
#include <qlayout.h>
#include <qtextedit.h>

extern double getScaleString(const Q_ULLONG value, QString& c);
extern double getScaleTens(const Q_ULLONG value, QString& c);

PropsPane::PropsPane(QWidget *parent, const char* name,WFlags flags):QWidget(parent,name,flags)
{
	QGridLayout *grid = new QGridLayout(this);
	text = new QTextEdit(this);
	text->setReadOnly(true);
	text->setFrameStyle(QFrame::NoFrame);
	grid->addWidget(text,0,0);
	
}

PropsPane::~PropsPane()
{

}

void PropsPane::update(const KNetDockIf* nif)
{
	QString txt = "";
	txt+=QString("IP4 address: %1 / %1\n").arg(nif->addrstat.ip).arg(nif->addrstat.mask);

	if (nif->devtype>PPP)txt+=QString("MAC address: %1\n").arg(nif->addrstat.mac);
	
	txt+=QString("MTU: %1\n").arg(nif->mtu);
	
	if (nif->devtype==PPP)txt+=QString("P-T-P Remote: %1\n").arg(nif->addrstat.ptp);
	
	if (nif->devtype==WIFI){
		txt+=QString("ESSID: %1\n").arg(nif->wstat.essid);
		txt+=QString("AP: %1\n").arg(nif->wstat.ap);
		txt+=QString("Link quality: %1 %\n").arg(nif->wstat.link_qual);
		QString pref=" ";
		if (nif->wstat.dbm)pref="dBm";
		txt+=QString("Signal level: %1 %2\n").arg(nif->wstat.signal_level,0,'f',2).arg(pref);
		txt+=QString("Noise level: %1 %2\n").arg(nif->wstat.noise_level,0,'f',2).arg(pref);
		QString c="";
		txt+=QString("Bitrate: %1 %2bits\n").arg(getScaleTens(nif->wstat.bitrate,c),0,'f',2).arg(c);
		if (nif->wstat.txpow==-1)txt+=QString("Radio off");
		else txt+=QString("Tx-Power: %1").arg(nif->wstat.txpow);
	}
	text->setText(txt);

}
