#ifndef KNAP_PREFERENCES_H
#define KNAP_PREFERENCES_H

#include <qstring.h>
#include <qstringlist.h>
#include <qcolor.h>

class KNAP_PathInfo
{
public:
  KNAP_PathInfo(QString p = QString::null,bool s = false,int d=-1)
  {
    path = p;
    shared = s;
    depth = d;
  }   
  QString toString()
  {
    QString tmp = path + "|";
    if(shared) tmp += "1";
    else tmp += "0";

    tmp += (QString("|") + QString().setNum(depth));

    return tmp;
  } 
  QString path;
  bool shared;
  int depth;
};
typedef QValueList<KNAP_PathInfo> PathInfoList;

class KNAP_Preferences
{
   public:   
  KNAP_Preferences();

public:
  ~KNAP_Preferences();

//  static KNAP_Preferences getPreferences();

  void load();
  void save();
  
  // the data
  //
  // user info
  QString username;
  QString password;
  QString email;
  bool newuser;

  // connection
  QString server;
  int port;
  int connectionspeed;
  bool firewall;

  // transfer
  QString downloadpath;
  int maxdownloads;
  int downloadtimeout;
  bool beeponfinish;

  int maxuploads;
  int maxuploadsperuser;

  // colours
  QColor normalcolor;
  QColor messagecolor;
  QColor notifycolor;
  QColor errorcolor;

  // library
  PathInfoList sharepaths;

  // misc
  bool clearonnewsearch;
  bool showfullfilepath;
  bool multiselect;
  bool languagefilter;
  bool useexternalplayer;
  QString playercommand;
};

#endif // KNAP_PREFERENCES_H
