/***************************************************************************
  librarypanel.h  -  description
  -------------------
begin                : Wed Jan 26 2000
copyright            : (C) 2000 by John Donoghue
email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNAP_LIBRARYPANEL_H
#define KNAP_LIBRARYPANEL_H

#include <qframe.h>
#include <qstringlist.h>
#include "songinfo.h"

#include "knap_preferences.h"

class KNAP_ListView;
class KNAP_Player;
class KNAP_PlayList;
class QListViewItem;
class QPoint;
class QLabel;
class QPopupMenu;
//class SongInfo;


/**the mp3 library panel for the mp3 library tab
 *@author John Donoghue
 */

class KNAP_LibraryPanel 
: public QFrame
{
   Q_OBJECT

signals:
   void play(const char *);
   void queuesong(const char *);
//   void rescan();

private slots:
   // slots for the player notifications
   void nextSong();
   void prevSong();
   void currSong(); 

   // internal menu slots
      void popupMenu( QListViewItem *, const QPoint &, int);
   void popupPlay();
   void popupQueue();

   // slot for dbl click in playlist
   //play ( QListBoxItem *item );

public slots:
      // clear the listview
      void clear();

      void rescan();
public: 
   KNAP_LibraryPanel(QWidget *parent=0, const char *name=0);
   virtual ~KNAP_LibraryPanel();

   int addDir(const char *name,bool shared=false,int depth=1);

   bool showLibraryPath() const;
   void setShowLibraryPath(bool yes);

   SongInfo *findSongInfo(const char *name, bool getall=false);

   bool isSharedSong(const char *name);

   SongInfo *getSong(int v);

   QStringList getAllSongNames();
//   KNAP_PathInfo getAllSongNames();
   
   SongList getAllSongs();

   KNAP_Player *getPlayer() { return player; }
private:
   void addItem(const QString &name,int bitrate,int freq,long size,
	 unsigned long seconds,bool shared);
private:
   KNAP_ListView *sharedlistview;
   QPopupMenu *sharedpopupmenu;
   QLabel *stats;

   bool showsharedpath;
   int sharedcount;

   double totalgig;
   
   KNAP_Player *player;
   KNAP_PlayList *playlist;
};

#endif
