
#ifndef EZTHREAD_H
#define EZTHREAD_H

#ifndef __WIN32__
  #include <pthread.h>
#else
  #include <windows.h>
#endif

/**a simple thread with mutex class
 *@author jade
 */

class EZThread
{
   private:
#ifndef __WIN32__
      pthread_mutex_t th_mutex;
      pthread_t th_id;
#else
      CRITICAL_SECTION critsect; // the mutex for the crital section
      HANDLE th_id;
#endif // __WIN32__

      bool done;
   public:
      EZThread();
      virtual ~EZThread();

      bool run();
      bool kill();

      bool isRunning();
   protected:
      void down();
      void up();
      bool trydown();

      virtual void run_method();
   private:
      static void *thread_task(EZThread *our_class);
};

#endif // EZTHREAD_H
