//
// C++ Interface:
//
// Description:
//
//
// Author: Christian Hubinger <e9806056@student.tuwien.ac.at>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFSELECTACTIVETARGET_H
#define KMFSELECTACTIVETARGET_H

#include "kmyfirewallselectactivetarget.h"

// QT Includes
#include <qstring.h>
#include <qguardedptr.h>
#include <qpoint.h>
class QListViewItem;

namespace KMF {
class KMFNetwork;
class KMFTarget;

class KMFSelectActiveTarget : public KMyFirewallSelectActiveTarget
{
		Q_OBJECT
	public: static KMFTarget* selectTarget( KMFNetwork* network, const QString& msg );
	
	public:
		KMFSelectActiveTarget ( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
		~KMFSelectActiveTarget();
		/*$PUBLIC_FUNCTIONS$*/
		void loadNetwork( KMFNetwork* );
		void setMessage( const QString& );
		KMFTarget *selectedTarget();
	
	public slots:
		/*$PUBLIC_SLOTS$*/
		void slotTargetSelected();
		void slotNewItemSelected( QListViewItem* item );
		void slotNewItemDBLClicked( QListViewItem*, const QPoint &, int  );
		void slotCancel();
		void slotOk();
		
	protected:
		/*$PROTECTED_FUNCTIONS$*/

	protected slots:
		/*$PROTECTED_SLOTS$*/

	private: // DATA
		KMFNetwork *m_network;
		QGuardedPtr<KMFTarget> m_target;
};
}
#endif

