/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/

#ifndef KMFLISTVIEWITEM_H
#define KMFLISTVIEWITEM_H

#include "kmflistview.h"

// QT includes
#include <qstring.h>
#include <quuid.h>
#include <qguardedptr.h>

// KDE includes

// Project includes

/**
@author Christian Hubinger
*/

namespace KMF {
class IPTable;
class IPTChain;
class IPTRule;
class IPTRuleOption;
class NetfilterObject;
class KMFNetZone;
class KMFNetHost;
class KMFTarget;
class KMFProtocol;
class KMFProtocolCategory;

class KDE_EXPORT KMFListViewItem : public KListViewItem {
public:
	KMFListViewItem( KListView *parent, NetfilterObject* );
	KMFListViewItem( KListViewItem *parent, NetfilterObject* );
	KMFListViewItem( KListView *parent, KListViewItem *after, NetfilterObject* );
	KMFListViewItem( KListViewItem *parent, KListViewItem *after, NetfilterObject* );

	virtual ~KMFListViewItem();

	NetfilterObject* netfilterObject() const;

	IPTable* table()  const {
		return m_table;
	};
	IPTChain* chain() const {
		return m_chain;
	};
	IPTRule* rule() const {
		return m_rule;
	};
	IPTRuleOption* ruleOption() const {
		return m_option;
	};

	KMFNetZone* zone() const {
		return m_zone;
	};

	KMFNetHost* host() const {
		return m_host;
	};
	
	KMFTarget* target() const {
		return m_target;
	};
	
	KMFProtocol* protocol() const {
		return m_protocol;
	};
	
	KMFProtocolCategory* protocolCategory() const {
		return m_protocolCategory;
	};


	bool isTopItem() const {
		return m_top;
	};
	
	int type();

	const QUuid& uuid() const {
		return m_obj_id;
	}

	void setupZoneView();
	void setupTargetView();
	void setupNetHostView();
	void setupProtocolView();
	void setupProtocolCategoryView();
	
	void deleteChildren();
	void setChildrenInUse( bool );
	void setTopItem( bool );
	void setInUse( bool );
	bool inUse();
	// enum { TABLE = 0, CHAIN = 1, RULE = 2, RULEOPTION = 3 , NETZONE = 4, NETHOST = 5,  KMFTARGET = 6 };

	void loadNetfilterObject( NetfilterObject* );
	virtual QString key( int column, bool ascending ) const;

private:
/*	IPTable *m_table;
	IPTChain *m_chain;
	IPTRule *m_rule;
	IPTRuleOption *m_option;
	KMFNetZone* m_zone;
	KMFNetHost* m_host;
	KMFTarget* m_target;
	KMFProtocol* m_protocol;
	KMFProtocolCategory* m_protocolCategory;
	NetfilterObject* m_object;*/
	
	QGuardedPtr<IPTable> m_table;
	QGuardedPtr<IPTChain> m_chain;
	QGuardedPtr<IPTRule> m_rule;
	QGuardedPtr<IPTRuleOption> m_option;
	QGuardedPtr<KMFNetZone> m_zone;
	QGuardedPtr<KMFNetHost> m_host;
	QGuardedPtr<KMFTarget> m_target;
	QGuardedPtr<KMFProtocol>  m_protocol;
	QGuardedPtr<KMFProtocolCategory> m_protocolCategory;
	QGuardedPtr<NetfilterObject> m_object;

	
	// int m_type;
	QUuid m_obj_id;
	bool m_top;
	bool m_inUse;
};
}
#endif
