/***************************************************************************
 begin                : Sat Mar 2 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kmfchainedit.h"
#include "kmfchainedit.moc"


//QT includes
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qlcdnumber.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qinputdialog.h>
#include <qtabwidget.h>

// KDE includes
#include <klocale.h>
#include <kdebug.h>
#include <kapplication.h> 
#include <kmessagebox.h>

// Project Includes
#include "../core/xmlnames.h"
#include "../core/kmfiptdoc.h"
#include "../core/kmfnetwork.h"
#include "../core/kmfundoengine.h"

// #include "../kmyfirewall.h" 





namespace KMF {
KMFChainEdit::KMFChainEdit( QWidget* parent, const char* name, WFlags fl )
		: KMyFirewallChainEditor( parent, name, fl ) {}
KMFChainEdit::~KMFChainEdit() {}

void KMFChainEdit::loadChain( IPTChain* chain ) {
	kdDebug() << "void KMFChainEdit::editChain(IPTChain* ch)" << endl;
	c_has_default_target->setChecked( false );
	c_enable_log->setChecked( false );
	c_log_limit->setChecked( false );
	c_log_burst->setChecked( false );
	c_log_prefix ->setChecked( false );
	// t_log_prefix->clear();
	m_tabWidget->setCurrentPage( 0 );

	if ( ! chain ) {
		setEnabled(false);
	} else {
		setEnabled(true);
		m_chain = chain;
		l_chain_name->setText( m_chain->name() );
		l_chain_table->setText( m_chain->table() ->name() );
		QPtrList<IPTRule> list_rules = m_chain->chainRuleset();
		QPtrList<IPTRule> list_feeds = m_chain->chainFeeds();
		QPtrList<IPTRule> list_fwds = m_chain->chainFwds();

		int num_rules = list_rules.count();
		int num_feeds = list_feeds.count();
		int num_fwds = list_fwds.count();

		kdDebug() << "num_rules = " << num_rules << endl;
		kdDebug() << "num_FEEDS = " << num_feeds << endl;
		kdDebug() << "num_fwds = " << num_fwds << endl;

		lcd_rules->display( num_rules );
		lcd_feeds->display( num_feeds );
		lcd_fwds->display( num_fwds );

		kdDebug() << "Found Chain " << m_chain->name() << endl;
		// show default target
		if ( m_chain->isBuildIn() ) {
			cb_target->clear();
			cb_target->insertItem( "ACCEPT" );
			cb_target->insertItem( "DROP" );
			QString tg = m_chain->defaultTarget();
			if ( tg == "ACCEPT" )
				cb_target->setCurrentItem( 0 );
			if ( tg == "DROP" )
				cb_target->setCurrentItem( 1 );
			c_has_default_target->setChecked( false );
		} else if ( m_chain->hasDefaultTarget() ) {
			cb_target->clear();
			cb_target->insertItem( "ACCEPT" );
			cb_target->insertItem( "DROP" );
			c_has_default_target->setEnabled( true );
			c_has_default_target->setChecked( true );
			QString tg = m_chain->defaultTarget();
			if ( tg == "ACCEPT" )
				cb_target->setCurrentItem( 0 );
			if ( tg == "DROP" )
				cb_target->setCurrentItem( 1 );
		} else {
			c_has_default_target->setEnabled( true );
			c_has_default_target->setChecked( false );
			connect( c_has_default_target, SIGNAL( toggled( bool ) ), cb_target, SLOT( setEnabled( bool ) ) );
			cb_target->clear();
			cb_target->insertItem( "ACCEPT" );
			cb_target->insertItem( "DROP" );
			cb_target->setEnabled( false );
		}
		// show logging settings
		bool logging = false;
		QString log_limit = "";
		QString log_prefix = "";
		QString log_burst = "";
		logging = m_chain->logging();
		log_limit = m_chain->logLimit();
		log_prefix = m_chain->logPrefix();
		log_burst = m_chain->logBurst();
		if ( logging ) {
			c_enable_log->setChecked( true );
			if ( ! log_prefix.isEmpty() && log_prefix != XML::Undefined_Value ) {
				kdDebug() << "Found Log Prefix: " << log_prefix << endl;
				c_log_prefix->setChecked( true );
				t_log_prefix->setText( log_prefix );
			} else {
				c_log_prefix->setChecked( false );
			}
			if ( !log_limit.isEmpty() && log_limit != XML::Undefined_Value ) {
				c_log_limit->setChecked( true );
				int i = log_limit.find( "/" );
				QString str_num = log_limit.left( i );
				QString interval = log_limit.remove( 0, i + 1 );
				if ( interval == "second" ) {
					cb_interval->setCurrentItem( 0 );
				} else if ( interval == "minute" ) {
					cb_interval->setCurrentItem( 1 );
				} else if ( interval == "hour" ) {
					cb_interval->setCurrentItem( 2 );
				} else {
					KMessageBox::sorry( this,  i18n( "Your config is not valid; it appears to be a bug." ) );
					c_log_limit->setChecked( false );
				}
				sb_limit->setValue( str_num.toInt() );
				kdDebug() << "Found Log Limit: " << str_num << "/" << interval << endl;
				if ( ! log_burst.isEmpty() && log_burst != XML::Undefined_Value ) {
					c_log_burst->setChecked( true );
					sb_burst->setValue( log_burst.toInt() );
				} else {
					c_log_burst->setChecked( false );
					// sb_burst->setValue( 5 );
				}
			} else {
				c_log_limit->setChecked( false );
			}
		} else {
			c_enable_log->setChecked( false );
			c_log_prefix->setChecked( false );
			c_log_limit->setChecked( false );
			c_log_burst->setChecked( false );
		}
	}
}



void KMFChainEdit::accept() {
	kdDebug() << "KMyFirewallChainEditor::slotSaveChainChanges()" << endl;
	KMFUndoEngine::instance()->startTransaction(
		m_chain, 
		i18n( "Edit Chain: %1 properties" ).arg( m_chain->name() ) 
	);
	bool log = c_enable_log->isChecked();
	bool log_limit = c_log_limit->isChecked();
	bool log_prefix = c_log_prefix->isChecked();
	bool log_burst = c_log_burst->isChecked();

	QString target = cb_target->currentText();
	kdDebug() << "Try to set Target to : " << target << endl;

	if ( m_chain->isBuildIn() ) {
		m_chain->setDefaultTarget( target );
	} else if ( c_has_default_target->isChecked() ) {
		m_chain->hasCustomDefaultTarget( true );
		m_chain->setDefaultTarget( target );
	} else
		m_chain->hasCustomDefaultTarget( false );

	QString str_log_limit = XML::Undefined_Value;
	QString str_log_prefix = XML::Undefined_Value;
	QString str_log_burst = XML::Undefined_Value;
	if ( log ) {
		kdDebug() << "You wanna Loga a little bit" << endl;
		// set log limit
		if ( log_prefix && ! t_log_prefix->text().isEmpty() ) {
			str_log_prefix = t_log_prefix->text();
			kdDebug() << "You wanna have as log prefix: " << str_log_prefix << endl;
		}
		if ( log_limit ) {  // set log limit
			QString str_limit_num = sb_limit->text();
			QString str_interval = cb_interval->currentText();
			str_log_limit = str_limit_num + "/" + str_interval;
			kdDebug() << "You wanna have " << str_log_limit << " as Logging limit" << endl;

			if ( log_burst ) {
				str_log_burst = sb_burst->text();
			} else {
				str_log_burst = XML::Undefined_Value;
			}
		} else {
			str_log_limit = XML::Undefined_Value;
		}
		m_chain->setDropLogging( true, str_log_limit, str_log_burst, str_log_prefix );
	} else {  // disable chain_logging
		str_log_limit = XML::Undefined_Value;
		str_log_prefix = XML::Undefined_Value;
		str_log_burst = XML::Undefined_Value;
		m_chain->setDropLogging( false, str_log_limit, str_log_burst, str_log_prefix );
	}

	m_chain->table()->changed();
	emit sigDocumentChanged();
	KMFUndoEngine::instance()->endTransaction();
	emit sigHideMe();
}

void KMFChainEdit::slotHelp() {
	kdDebug() << "void KMFChainEdit::slotHelp()" << endl;
	kapp->invokeHelp( "chains" );
}
void KMFChainEdit::reject() {
	kdDebug() << "void KMFChainEdit::reject()" << endl;
	emit sigHideMe();
}

}
