//
// C++ Interface: kprocesswrapper
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFKPROCESSWRAPPER_H
#define KMFKPROCESSWRAPPER_H


// QT Includes
#include <qobject.h>
#include <qstring.h>

// KDE includes


class KProcess;

// Project includes
namespace KMF {
class KMFTarget;

/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/
class KProcessWrapper : public QObject {
Q_OBJECT

//############# Beginn static stuff ##############	
public:
	/** return the one and only instance */
	static KProcessWrapper* instance();
private:	
	static KProcessWrapper* m_instance;
	
//############# End static stuff ##############

public:
    KProcessWrapper( QObject*, const char* );

    ~KProcessWrapper();

	bool isRunning();
	
	const QString& jobName() const {
		return m_jobName;
	}
	const QString& stdOut() const {
		return m_stdOut;
	}
	const QString& stdErr() const {
		return m_stdErr;
	}
	const QString& stdCombined() const {
		return m_allOut;
	}
	const int exitStatus() const {
		return m_status;
	}
	const bool exitedNormal() const {
		return m_exitedNormal;
	}
	
public slots:
	void slotKillJob();

	void slotStartLocalJob( const QString& jobName, const QString& command, bool useKdeSu /* = false */, bool synchronous /* = false */); 
	void slotStartRemoteJob( const QString& jobName, const QString& scriptFile, KMFTarget* execHost ); 

protected slots:
	void slotReceivedOutput( KProcess*, char*, int );
	void slotReceivedError( KProcess*, char*, int );
	void slotProcessExited( KProcess* );
		

private:
	QString* m_stderrbuf;
	QString* m_stdoutbuf;
	
	QString m_jobName;
	QString m_allOut;
	int m_status;
	bool m_exitedNormal;
	
	QString m_stdOut;
	QString m_stdErr;
	KProcess* m_childproc;

signals:
	void sigProcessFinished( const QString& jobName, int status, bool exitedNormal, const QString& stdOut, const QString& stdErr, const QString& completeOut );
	
	void sigReceivedStdOut( const QString& jobName, const QString& stdOut );
	void sigReceivedStdErr( const QString& jobName, const QString& stdOut );
};

}

#endif
