/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DEVICE_H
#define DEVICE_H
#include <qobject.h>
#include <qmutex.h> 
/**
@author Marco Gulino
*/
class Device : public QObject
{
Q_OBJECT
public:
    Device(const char* path="/dev/mobile");
    ~Device();
    bool isLocked() { return locked; }
    int sendCommand(const char* cmd, int timeout=500);
    char* getBuffer() { return buffer; }
	bool isInitialized() { if (modem == -1 ) return false; else return true; }
	bool isPDU() { return pdu; }
private:


protected:
    void setupModem();
	bool locked;
	char buffer[1024*1024];
	long modem;
    QMutex mutex;
	bool pdu;
public slots:
    int sendChar(unsigned char c);
    char* getDevBuffer();
};

#endif
