/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kmobiletools.h"

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kuniqueapplication.h>
#include <kapplication.h>
#include <dcopclient.h>

#include "gsm.h"

#define VERSION "0.4.3.3"
#define APP_VERSION "0.4.3.3"
extern GSM* d_gsm;
DCOPClient* dcopclient;

static const char description[] =
    I18N_NOOP("A KDE application for mobile phone management");

static const char version[] = VERSION;

static KCmdLineOptions options[]={
									 { "nd", I18N_NOOP("Do not dial given phone number."), 0 },
									 { "+[Number]", I18N_NOOP( "Phone number to call." ), 0 },
									 KCmdLineLastOption 
								 };

int main(int argc, char **argv)
{
	d_gsm=NULL;
	
	KAboutData about("kmobiletools", I18N_NOOP("KMobileTools"), version, description,
		KAboutData::License_GPL, "(C) 2004 Marco Gulino", 0, 
		"http://kmobiletools.berlios.de");
		
	about.addAuthor( "Marco Gulino", I18N_NOOP("Main developer and Italian translator"), "marco.gulino@gmail.com" );
	about.addCredit( "Alexander Rensmann", I18N_NOOP("Siemens support patch"), "zerraxys@gmx.net" );
	about.addCredit( "Stefano Massera", I18N_NOOP("Main icon artwork"), "teradsl@tin.it" );
	about.addCredit( "Francesco Pedrini", I18N_NOOP("Debian packages, main site support"), "francesco.pedrini@gmail.com" );
	about.addCredit( "Roberto Marcellini", I18N_NOOP("Main site support"), "ankuba@virgilio.it" );

	about.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names")
 ,I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));
    KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions( options );
//	#define USE_KUNIQUEAPP
	#ifdef USE_KUNIQUEAPP
	kdDebug() << "Using KUniqueApplication\n";
	KUniqueApplication::addCmdLineOptions();
	if ( !KUniqueApplication::start() ) {
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		if(args->count()<=0) return 0;
		DCOPClient client;
		client.registerAs("kmobiletoolslauncher");
		if(client.send("kmobiletools", "KMobileToolsInterface", "callNumber(QString)", QString( args->arg(0) ) ) )
		{
			if(args->isSet("nd") ) return 0;
			if(client.send("kmobiletools", "KMobileToolsInterface", "dial_Clicked()", QString("") ) ) return 0;
		}
		return -1;
    }
    KUniqueApplication app;
#else
	kdDebug() << "KUniqueApplication disabled: using KApplication\n";
	KApplication app;
#endif

    app.dcopClient()->registerAs( app.name(), false);

    kmobiletools *mainWin = 0;
    if (app.isRestored())
    {
        RESTORE(kmobiletools);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        mainWin = new kmobiletools();
        app.setMainWidget( mainWin );
        mainWin->show();
        args->clear();
    }
	dcopclient=app.dcopClient();
    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

