/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef D_TERMINAL_H
#define D_TERMINAL_H

#include "device.h"
#include <ktextedit.h>
#include <kdialog.h>
#include <qlayout.h>

/**
@author Marco Gulino
*/
class modemText : public KTextEdit
{
Q_OBJECT
public:
	modemText(Device* c_device, QWidget *parent=0L, const char *name=0);
	void keyPressEvent(QKeyEvent *k);
	void myReturn();
private:
	Device* device;
	QString command;
};

class d_Terminal : public KDialog
{
Q_OBJECT
public:
    d_Terminal(Device* c_device, QWidget *parent = 0, const char *name = 0);
    ~d_Terminal();
private:
	Device* device;
    modemText* modemDiag;
    QGridLayout* ui_TerminalLayout;
public slots:
    void readText();

};

#endif
