/***************************************************************************
 *   Copyright (C) 2009 by Spiros Georgaras                                *
 *   sng@hellug.gr                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//#define DO_NOT_TRANSLATE
//#define THANK_PEOPLE
 
#include "about.h"

//================================
aboutMhtConvert::aboutMhtConvert()
	: QWidget( 0, "aboutMhtConvert", Qt::WStyle_Customize | Qt::WType_Modal | Qt::WStyle_DialogBorder | Qt::WStyle_Title){

}
//================================
aboutMhtConvert::~aboutMhtConvert(){

}
//================================
aboutMhtConvert::aboutMhtConvert(QPixmap programIcon)
	: QWidget( 0, "aboutMhtConvert", Qt::WStyle_Customize | Qt::WType_Modal | Qt::WStyle_DialogBorder | Qt::WStyle_Title){
	

    fAboutLayout = new QVBoxLayout( this, 11, 6, "fAboutLayout"); 

    layout12_2 = new QHBoxLayout( 0, 0, 6, "layout12_2"); 

    layout10 = new QHBoxLayout( 0, 0, 6, "layout10"); 

    pixmapLabel1 = new QLabel( this, "pixmapLabel1" );
    pixmapLabel1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)5, 0, 0, pixmapLabel1->sizePolicy().hasHeightForWidth() ) );
    pixmapLabel1->setScaledContents( FALSE );
    layout10->addWidget( pixmapLabel1 );

    lblVersion = new QLabel( this, "lblVersion" );
    lblVersion->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, 0, 0, lblVersion->sizePolicy().hasHeightForWidth() ) );
    lblVersion->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
    layout10->addWidget( lblVersion );
    layout12_2->addLayout( layout10 );
    spacer9_2 = new QSpacerItem( 0, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout12_2->addItem( spacer9_2 );
    fAboutLayout->addLayout( layout12_2 );

    tabWidget2 = new QTabWidget( this, "tabWidget2" );
    tabWidget2->setFocusPolicy( QTabWidget::TabFocus );

    tab = new QWidget( tabWidget2, "tab" );
    tabLayout = new QVBoxLayout( tab, 11, 6, "tabLayout"); 
    spacer12 = new QSpacerItem( 31, 41, QSizePolicy::Minimum, QSizePolicy::Expanding );
    tabLayout->addItem( spacer12 );

    layout13 = new QHBoxLayout( 0, 0, 6, "layout13"); 
    spacer8_2 = new QSpacerItem( 176, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout13->addItem( spacer8_2 );

    layout16_3 = new QVBoxLayout( 0, 0, 6, "layout16_3"); 

    shortDescription = new QLabel( tab, "shortDescription" );
    shortDescription->setAlignment( int( QLabel::AlignCenter ) );
    layout16_3->addWidget( shortDescription );

    layout15_3 = new QHBoxLayout( 0, 0, 6, "layout15_3"); 
/*
    lblCr = new QLabel( tab, "lblCr" );
    lblCr->setAlignment( int( QLabel::AlignCenter ) );
    layout15_3->addWidget( lblCr );

    urlGwenview = new KURLLabel( tab, "urlGwenview" );
    layout15_3->addWidget( urlGwenview );
    layout16_3->addLayout( layout15_3 );

    lblImage = new QLabel( tab, "lblImage" );
    lblImage->setAlignment( int( QLabel::AlignCenter ) );
    layout16_3->addWidget( lblImage );
*/
    lblC = new QLabel( tab, "lblC" );
    lblC->setAlignment( int( QLabel::AlignCenter ) );
    layout16_3->addWidget( lblC );

    gURL = new KURLLabel( tab, "gURL" );
    gURL->setAlignment( int( KURLLabel::AlignCenter ) );
    layout16_3->addWidget( gURL );
    layout13->addLayout( layout16_3 );
    spacer9 = new QSpacerItem( 175, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout13->addItem( spacer9 );
    tabLayout->addLayout( layout13 );
    spacer13_2 = new QSpacerItem( 21, 51, QSizePolicy::Minimum, QSizePolicy::Expanding );
    tabLayout->addItem( spacer13_2 );
    tabWidget2->insertTab( tab, QString("") );
	 
	 #ifdef THANK_PEOPLE

    tab_2 = new QWidget( tabWidget2, "tab_2" );
    tabLayout_2 = new QHBoxLayout( tab_2, 5, 6, "tabLayout_2"); 

    thanks = new KTextBrowser( tab_2, "thanks" );
    thanks->setWordWrap( KTextBrowser::FixedColumnWidth );
    thanks->setWrapColumnOrWidth( 67 );
    tabLayout_2->addWidget( thanks );
    tabWidget2->insertTab( tab_2, QString("") );

	 #endif
	 
    TabPage = new QWidget( tabWidget2, "TabPage" );
    TabPageLayout = new QHBoxLayout( TabPage, 5, 6, "TabPageLayout"); 

    license = new KTextBrowser( TabPage, "license" );
    license->setWordWrap( KTextBrowser::FixedColumnWidth );
    TabPageLayout->addWidget( license );
    tabWidget2->insertTab( TabPage, QString("") );
    fAboutLayout->addWidget( tabWidget2 );

    Layout1 = new QHBoxLayout( 0, 0, 6, "Layout1"); 
    Horizontal_Spacing2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( Horizontal_Spacing2 );

    buttonClose = new QPushButton( this, "buttonClose" );
    buttonClose->setAutoDefault( TRUE );
    buttonClose->setDefault( TRUE );
    Layout1->addWidget( buttonClose );
    fAboutLayout->addLayout( Layout1 );
	 resize( QSize(530, 320).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    //connect( buttonClose, SIGNAL( clicked() ), this, SLOT( accept() ) );
	 connect( buttonClose, SIGNAL( clicked() ), this, SLOT( closeIt() ) );
    connect( gURL, SIGNAL( leftClickedURL(const QString&) ), this, SLOT( gURLClicked(const QString&) ) );
    connect( gURL, SIGNAL( middleClickedURL(const QString&) ), this, SLOT( gURLClicked(const QString&) ) );
    connect( gURL, SIGNAL( rightClickedURL(const QString&) ), this, SLOT( gURLClicked(const QString&) ) );
    //connect( urlGwenview, SIGNAL( leftClickedURL(const QString&) ), this, SLOT( gURLClicked(const QString&) ) );
    //connect( urlGwenview, SIGNAL( middleClickedURL(const QString&) ), this, SLOT( gURLClicked(const QString&) ) );
    //connect( urlGwenview, SIGNAL( rightClickedURL(const QString&) ), this, SLOT( gURLClicked(const QString&) ) );
	 
	 
	 
    setCaption( QString(i18n("About %1")).arg("kmhtConvert") );
    
//	 lblCr->setText( i18n( "created as an external tool for" ) );
//    urlGwenview->setText( QString::null );
//    urlGwenview->setProperty( "url", QString::null );
//   lblImage->setText( i18n( "the image viewer for KDE" ) );
    
	 tabWidget2->changeTab( tab, i18n( "&About" ) );
	 #ifdef THANK_PEOPLE
    tabWidget2->changeTab( tab_2, i18n( "&Thanks To" ) );
	 #endif
    tabWidget2->changeTab( TabPage, i18n( "&License Agreement" ) );
    buttonClose->setText( QString::null );
    buttonClose->setAccel( QKeySequence( QString::null ) );
	 
	 
	 
	 pixmapLabel1->setPixmap(programIcon);
    shortDescription->setText(ab->shortDescription());
    QString cop="\n"+ab->copyrightStatement();
    lblC->setText(cop);
	     QString t=QString(i18n("%1 %2 (Using KDE %3)")).arg("kmhtConvert").arg(ab->version()).arg(KDE_VERSION_STRING);
    t.prepend("<b><nobr>");t+="</nobr></b>";
    lblVersion->setText(t);
    lblVersion->setScaledContents(TRUE);
	 gURL->setText(ab->homepage());
	 gURL->setURL(ab->homepage());
	 buttonClose->setMinimumSize( QSize( 100, 0 ) );
    buttonClose->setText( QString(i18n( "&Close" )) );
    buttonClose->setAccel( QKeySequence( "Alt+C"));
    license->setText(ab->license());
    license->setPaletteBackgroundColor(tabWidget2->paletteBackgroundColor());
	 //license->setMinimumSize( QSize( 260, 300 ) );
    //thanks->setPaletteBackgroundColor(tabWidget2->paletteBackgroundColor());
	
	KConfigBase *config = KGlobal::config();
	config->setGroup("Locale");
	QString lang=config->readEntry("Language"); 
	//qWarning("language = %s",lang.latin1());
	
	 
//	if(en->language().find("en",0)!=0){
	//if(en.country()!="gb" && en.country()!="us"){
	if(lang!=QString::null && lang.find("en",0)!=0){
		TabPage = new QWidget( tabWidget2, "TabPage" );
		TabPageLayout = new QHBoxLayout( TabPage, 5, 6, "TabPageLayout"); 
		KTextBrowser* trans;
		trans = new KTextBrowser( TabPage, "trans" );
		trans->setWordWrap( KTextBrowser::FixedColumnWidth );
		trans->setWrapColumnOrWidth( 40 );
		TabPageLayout->addWidget( trans );
		#ifdef THANK_PEOPLE
		tabWidget2->insertTab( TabPage, QString(""),2 ); //with thanks
		#else
		tabWidget2->insertTab( TabPage, QString(""),1 ); //without thanks
		#endif
		QValueList< KAboutTranslator > v=ab->translators();
		if(KDE_VERSION_MINOR==1) trans->setPaletteBackgroundColor(tabWidget2->paletteBackgroundColor());
		else trans->setWordWrap(KTextBrowser::WidgetWidth);
		tabWidget2->changeTab( TabPage, QString(i18n( "T&ranslation" )) );
		if(v.empty()){
			if(KDE_VERSION_MINOR==1) trans->setWrapColumnOrWidth( 120 );
			#ifdef DO_NOT_TRANSLATE
			t="<p>There is no translation available for your language.</p><p>If you would like to translate the program please wait until a <font color=\"Red\"><b>string freeze</b></font> for translators is announced.</p>";
			#else
			t="<p>There is no translation available for your language.<p><p>If you would like to translate the program please feel free to do so.<p></p>When you are done, <a href=\"mailto:sng@hellug.gr?subject=New translation for kmhtConvert\">send me</a> the resulting po file and I will add a link to it in the <a href=\"http://users.otenet.gr//~geosp//kmhtconvert//download.html\">download page</a> of kmhtConvert site. </p><p>Your translation will be included in the next kmhtConvert release.<p><p>For more information on traslating KDE programs, please visit the <a href=\"http://i18n.kde.org//\">KDE Internationalization</a> site.</p>";
			#endif
		}else{
			KAboutTranslator kAbTr;
			t="";
			for(uint i=0;i<v.count();i++){
				kAbTr=v[i];
				//t+=QString("<p>&nbsp;&nbsp;%1<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"mailto:%2\">%3</a></p>").arg(kAbTr.name(),kAbTr.emailAddress(),kAbTr.emailAddress());
				t+=QString("<p>&nbsp;&nbsp;%1<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"mailto:%2\">%3</a></p>").arg(kAbTr.name()).arg(kAbTr.emailAddress()).arg(kAbTr.emailAddress());
			}
			t+=ab->aboutTranslationTeam();
		}
		trans->setText(t);
	}
	 #ifdef THANK_PEOPLE
// 	 t="<p><b>Aurelien Gateau</b><br>";
//     t+=QString(i18n("For all the help he's offered"));
//     t+="</p><p><b>Jan Schubert</b><br>";
//     t+=QString(i18n("For giving me the idea to use timestamping information to GwenRename, and providing Exif images for testing."));
//     t+="<p><b>Charles Barcza</b><br>";
//     t+=QString(i18n("For helping me debug v 0.9.9"));
//     t+="</p>";
//     thanks->setText(t);
	 #endif
    buttonClose->setFocus();
}
void aboutMhtConvert::gURLClicked( const QString &op )
{
     KRun opBr(op);
     opBr.runURL(op,"text/html",FALSE);
}
void aboutMhtConvert::closeIt(){
	close(TRUE);
}
void aboutMhtConvert::keyReleaseEvent ( QKeyEvent * e ){
	if(e->key()==Qt::Key_Enter || e->key()==Qt::Key_Return){
		e->accept();
		close(TRUE);
	}else e->ignore();
}
#include "about.moc"
