/***************************************************************************
                          notificationmanager.cpp - manage the notifications
                            stack and updates them as needed
                             -------------------
    begin                : Thursday April 19 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "notificationmanager.h"

#include "../currentaccount.h"

#include <kdebug.h>

// Initialize the instance to zero
NotificationManager* NotificationManager::instance_(0);



// Class constructor
NotificationManager::NotificationManager()
{
  stack_.setAutoDelete( true );
}



// Class destructor
NotificationManager::~NotificationManager()
{
  QDictIterator<PassivePopup> it( stack_ );
  for( ; it.current(); ++it )
    delete it.current();
}



// Return the current tray widget object
QWidget *NotificationManager::getTrayWidget()
{
  return trayWidget_;
}


// Insert a new popup in the stack if needed, or change an existing one
void NotificationManager::notify( QObject *caller, PassivePopup::PopupProperties props )
{
  PassivePopup *popup = 0;

  if( stack_[ props.source ] )
  {
#ifdef KMESSDEBUG_NOTIFICATIONMANAGER
    kdDebug() << "NotificationManager::notify() - a popup for " << props.source << " is already in the stack, updating it" << endl;
#endif

    popup = stack_[ props.source ];
    popup->change( props );

    popup->show();

    return;
  }

#ifdef KMESSDEBUG_NOTIFICATIONMANAGER
  kdDebug() << "NotificationManager::notify() - creating new popup for " << props.source << " in the stack" << endl;
#endif

  // Set the new popup's position
  int minY = INT_MAX, current;
  QDictIterator<PassivePopup> it( stack_ );
  for( ; it.current(); ++it )
  {
    current = it.current()->getPosition().y();
    if( current < minY )
      minY = current;
  }
  props.position = trayWidget_->mapToGlobal( QPoint( 0, 0 ) );
  if( minY != INT_MAX )
  {
    // TODO Adding like, 10px to this would make the balloons touch. But I haven't found a method to obtain the distance
    // value that is actually used by KDE to space them.
    props.position.ry() = minY;
  }

  props.timeout = CurrentAccount::instance()->getNotificationDuration() * 1000;

  popup = new PassivePopup( trayWidget_, props );
  stack_.insert( props.source, popup );

  connect( popup,  SIGNAL( activate( QStringList, QObject * ) ),
           caller,   SLOT( activate( QStringList, QObject * ) ) );
  connect( popup,  SIGNAL( dying( QString ) ),
           this,     SLOT( remove( QString ) ) );

  popup->show();
}



// Return a singleton instance of the current account
NotificationManager* NotificationManager::instance()
{
  // If the instance is null, create a new manager and return that.
  if ( instance_ == 0 )
  {
    instance_ = new NotificationManager();
  }
  return instance_;
}



// Remove a timed out popup from the stack
void NotificationManager::remove( QString source )
{
  stack_.remove( source );

#ifdef KMESSDEBUG_NOTIFICATIONMANAGER
  kdDebug() << "NotificationManager::remove() - deleted popup for " << source << " from the stack" << endl;
#endif
}



// Set the tray widget object that will be used
void NotificationManager::setTrayWidget( QWidget *widget )
{
  trayWidget_ = widget;
}



#include "notificationmanager.moc"
