/***************************************************************************
                          voiceconversion.h  -  description
                             -------------------
    begin                : 30 2003
    copyright            : (C) 2003 by Mike K. Bennett
                           (C) 2004 by Steve gigijoe
    email                : mkb137b@hotmail.com, stevegigijoe@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VOICECONVERSATION_H
#define VOICECONVERSATION_H

#include <qwidget.h>
//#include <qthread.h>
#include "mimeapplication.h"

// Forward declarations
class MimeMessage;
class UserAgent;

class VoiceConversation : public MimeApplication
{
  Q_OBJECT

  public:
    // The constructor
                           VoiceConversation(const QString &contactHandle);
    // The destructor
                          ~VoiceConversation();
    // Return the application's GUID
    static QString         getAppId();
    // User stop voice conversation
    void                   userAborted();

  private: // Private methods
    // Step one of a contact-started chat: the contact invites the user
    void                   contactStarted1_ContactInvitesUser(const MimeMessage& message);
    // Step two of a contact-started chat: the user accepts
    void                   contactStarted2_UserAccepts();
    // Step three of a contact-started chat: the contact confirms the accept
    void                   contactStarted3_ContactConfirmsAccept(const MimeMessage& message);
    // Return a cancel message to display
    QString                getUserAbortMessage() const;
    // Start the conversion
    void                   startConversation( bool connectToRemote );
    // Step one of a user-started chat: the user invites the contact
    void                   userStarted1_UserInvitesContact();
    // Step two of a user-started chat: the contact accepts
    void                   userStarted2_ContactAccepts(const MimeMessage& message);
    // Step three of a user-started chat: the user confirms the accept
    void                   userStarted3_UserPrepares();

  private: // Private attributes
    // The remote IP address
    QString                 remotePublicIp_, remotePrivateIp_, remoteIp_, remoteUPnP_;

    QString                 remotePort_;

    QString                 connectionType_;

    bool                    foundUPnPDevice_;

    UserAgent              *userAgent_;
};

#endif
